% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_dispensing_models.R
\name{f_fit_di}
\alias{f_fit_di}
\title{Linear Mixed-Effects Model Fit for Dispensed Doses}
\usage{
f_fit_di(df, model, nreps, showplot = TRUE)
}
\arguments{
\item{df}{The subject-level dosing data, including \code{usubjid},
\code{day}, \code{drug}, and \code{dose}.}

\item{model}{The model used to analyze the dispensed doses, with
options including "constant", "lm" (linear model), and
"lme" (linear mixed-effects model).}

\item{nreps}{The number of simulations for drawing posterior model
parameters.}

\item{showplot}{A Boolean variable that controls whether or not to
show the residual plot. It defaults to \code{TRUE}.}
}
\value{
A list of results from the model fit, including

* \code{model}: The specific model used in the analysis.

* \code{mud}: The estimated mean dose.

* \code{vmud}: The estimated variance of \code{mud}.

* \code{sigmab}: The estimated between-subject standard deviation.

* \code{sigmae}: The estimated within-subject residual standard deviation.

* \code{aic}: The Akaike Information Criterion value for the model fit.

* \code{bic}: The Bayesian Information Criterion value for the model fit.

Additionaly, the function provies:

* A residual plot.

* Posterior draws of model parameters.

* Subject random effects.
}
\description{
Fits a linear mixed-effects model to the dispensed doses.
}
\examples{
library(dplyr)

df <- df2 \%>\%
  mutate(arrivalTime = as.numeric(randdt - trialsdt + 1))

vf <- visitview2 \%>\%
  inner_join(df, by = "usubjid") \%>\%
  mutate(day = as.numeric(date - randdt + 1)) \%>\%
  select(drug, drug_name, dose_unit, usubjid, treatment,
         treatment_description, arrivalTime,
         time, event, dropout, day, dispensed_quantity) \%>\%
  group_by(drug, drug_name, dose_unit, usubjid, treatment,
           treatment_description, arrivalTime,
           time, event, dropout, day) \%>\%
  summarise(dose = sum(dispensed_quantity),
            .groups = "drop_last") \%>\%
  mutate(cum_dose = cumsum(dose)) \%>\%
  group_by(drug, drug_name, dose_unit, usubjid) \%>\%
  mutate(row_id = row_number())

vf1 <- vf \%>\% filter(drug == 3)
fit_di <- f_fit_di(vf1, model = "lm", nreps = 200)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
