% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sl_npreg.R
\name{SL.npreg}
\alias{SL.npreg}
\title{Super learner wrapper for kernel regression}
\usage{
SL.npreg(Y, X, newX, family = gaussian(), obsWeights = rep(1, length(Y)),
  rangeThresh = 1e-07, ...)
}
\arguments{
\item{Y}{A vector of outcomes.}

\item{X}{A matrix or data.frame of training data predictors.}

\item{newX}{A test set of predictors.}

\item{family}{Not used by the function directly, but ensures compatibility with \code{SuperLearner}.}

\item{obsWeights}{Not used by the function directly, but ensures compatibility with \code{SuperLearner}.}

\item{rangeThresh}{If the the range of the outcomes is smaller than this number, the method
returns the empirical average of the outcomes. Used for computational expediency and stability.}

\item{...}{Other arguments (not currently used).}
}
\description{
Kernel regression based on the \href{https://CRAN.R-project.org/package=np}{np}
package. Uses leave-one-out cross-validation to fit a kernel regression.
See \code{?npreg} for more details.
}
\examples{
# simulate data
set.seed(1234)
n <- 100
X <- data.frame(X1 = rnorm(n))
Y <- X$X1 + rnorm(n)
# fit npreg
fit <- SL.npreg(Y = Y, X = X, newX = X)
}
