% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logodds_fn.R
\name{evaluate_trt_spec_theta_eif}
\alias{evaluate_trt_spec_theta_eif}
\title{get a matrix of eif estimates for the treatment-specific CDF estimates}
\usage{
evaluate_trt_spec_theta_eif(
  trt_spec_cdf_est,
  trt_spec_prob_est,
  trt_level,
  treat,
  out,
  out_levels
)
}
\arguments{
\item{trt_spec_cdf_est}{Estimated conditional CDF for \code{trt_level}.}

\item{trt_spec_prob_est}{Estimated propensity for \code{trt_level}.}

\item{trt_level}{Treatment level}

\item{treat}{A \code{numeric} vector containing treatment status. Missing
values are not allowed unless the corresponding entry in \code{out} is also missing. 
Only values of 0 or 1 are treated as actual treatment levels. Any other value is assumed 
to encode a value for which the outcome is missing and the corresponding outcome value is 
ignored.}

\item{out}{A \code{numeric} vector containing the outcomes. Missing outcomes are 
allowed.}

\item{out_levels}{A \code{numeric} vector containing all ordered levels of the 
outcome.}
}
\value{
matrix of EIF estimates for CDF.
}
\description{
get a matrix of eif estimates for the treatment-specific CDF estimates
}
