% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mannwhitney_fn.R
\name{bca_mannwhitney}
\alias{bca_mannwhitney}
\title{Compute a BCa bootstrap confidence interval for the Mann-Whitney parameter. The code is 
based on the slides found here: http://users.stat.umn.edu/~helwig/notes/bootci-Notes.pdf}
\usage{
bca_mannwhitney(
  treat,
  covar,
  out,
  nboot,
  treat_form,
  out_levels,
  out_form,
  mannwhitney_est,
  out_model,
  alpha = 0.05
)
}
\arguments{
\item{treat}{A \code{numeric} vector containing treatment status. Missing
values are not allowed unless the corresponding entry in \code{out} is also missing. 
Only values of 0 or 1 are treated as actual treatment levels. Any other value is assumed 
to encode a value for which the outcome is missing and the corresponding outcome value is 
ignored.}

\item{covar}{A \code{data.frame} containing the covariates to include in the working
proportional odds model.}

\item{out}{A \code{numeric} vector containing the outcomes. Missing outcomes are 
allowed.}

\item{nboot}{Number of bootstrap replicates used to compute bootstrap confidence
intervals.}

\item{treat_form}{The right-hand side of a regression formula for the working model of
treatment probability as a function of covariates}

\item{out_levels}{A \code{numeric} vector containing all ordered levels of the 
outcome.}

\item{out_form}{The right-hand side of a regression formula for the working proportional 
odds model. NOTE: THIS FORMULA MUST NOT SUPPRESS THE INTERCEPT.}

\item{mannwhitney_est}{The point estimate of the Mann-Whitney parameter.}

\item{out_model}{Which R function should be used to fit the proportional odds 
model. Options are \code{"polr"} (from the \code{MASS} package), 
"vglm" (from the \code{VGAM} package), or \code{"clm"} (from the \code{ordinal} package).}

\item{alpha}{Level of confidence interval.}
}
\value{
Confidence interval for the Mann-Whitney parameter
}
\description{
Compute a BCa bootstrap confidence interval for the Mann-Whitney parameter. The code is 
based on the slides found here: http://users.stat.umn.edu/~helwig/notes/bootci-Notes.pdf
}
