% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allgenerics.R
\name{getStationaryLaw}
\alias{getStationaryLaw}
\title{Stationary laws of the drifting Markov Model}
\usage{
getStationaryLaw(x, pos, all.pos = FALSE, internal = FALSE, ncpu = 2)
}
\arguments{
\item{x}{An object for which the stationary laws of the DMM can be computed.}

\item{pos}{A positive integer giving the position along the sequence on which the stationary law of the DMM should be computed}

\item{all.pos}{`FALSE` (default, evaluation at position index) ; `TRUE` (evaluation for all position indices)}

\item{internal}{`FALSE` (default) ; `TRUE` (for internal use of the initial law computation)}

\item{ncpu}{Default=2. Represents the number of cores used to parallelized computation. If ncpu=-1, then it uses all available cores.}
}
\value{
A vector or matrix of stationary law probabilities
}
\description{
Generic function evaluating the stationary law of a model \code{x} at a given position \code{pos} or at every position \code{all.pos}
}
\details{
Stationary law at position t is evaluated by solving \eqn{\mu_t \ \pi_{\frac{t}{n}} = \mu}
}
\references{
\insertRef{BaVe2018}{drimmR}
\insertRef{Ver08}{drimmR}
}
\author{
Alexandre Seiller
}
