% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dr_replace.R
\name{dr_replace}
\alias{dr_replace}
\title{Replacing problematic observations from the monitoring period}
\usage{
dr_replace(.data, sourceVar, cleanVar = NULL, overwrite = FALSE, dateVar = NULL,
    timeVar = NULL, from = NULL, to = NULL, tz = NULL, exp)
}
\arguments{
\item{.data}{A tbl}

\item{sourceVar}{Name of variable to replace missing values in}

\item{cleanVar}{New variable name for cleaned data}

\item{overwrite}{A logical scalar. Should the current variable be overwritten instead
of creating a new variable?}

\item{dateVar}{Name of variable containing date data}

\item{timeVar}{Name of variable containing time data}

\item{from}{Beginning date and (optionally) time to remove observations}

\item{to}{End date and (optionally) time to remove observations}

\item{tz}{String name of timezone, defaults to system's timezone}

\item{exp}{Unquoted expression}
}
\value{
An object of the same class as \code{.data} with specified observations
    recoded as missing.
}
\description{
\code{dr_replace()} includes two approaches for identifying problematic
    observations for specific measurements that should be recoded as missing
    values (\code{NA}).
}
\details{
During monitoring, a sensor malfunction may impact only a single element of
    a given reading. Removing the entire observation may therefore be imprudent.
    \code{dr_replace()} provides two methods for identifying these values and declaring
    them as missing. Values can be identified by specifying one or two timepoints
    in the data where problematic measurements begin, end, or fall between. Values
    can also be identified based on a problematic sensor value or range of values
    using an expression.
}
\examples{
testData <- data.frame(
   Date = c("9/18/2015", "9/18/2015", "9/18/2015", "9/18/2015", "9/19/2015", "9/21/2015"),
   Time = c("12:10:49", "12:15:50", "12:20:51", "12:25:51", "12:30:51", "12:35:51"),
   Temp = c(14.76, 14.64, 14.57, 14.51, 14.50, 14.63),
   SpCond = c(0.754, 0.750, 0.750, 0.749, 0.749, 0.749),
   stringsAsFactors = FALSE
 )

 dr_replace(testData, sourceVar = Temp, dateVar = Date, timeVar = Time,
     from = "2015-09-19 12:30:51", to = "2015-09-21 12:35:51")
 dr_replace(testData, sourceVar = Temp, dateVar = Date, timeVar = Time,
     from = "2015-09-19", to = "2015-09-21")
 dr_replace(testData, sourceVar = Temp, dateVar = Date, timeVar = Time, from = "2015-09-19")
 dr_replace(testData, sourceVar = Temp, dateVar = Date, timeVar = Time, to = "2015-09-19")
 dr_replace(testData, sourceVar = Temp, cleanVar = temp2, dateVar = Date, timeVar = Time,
     to = "09/19/2015 12:35:51")
 dr_replace(testData, sourceVar = Temp, overwrite = TRUE, exp = Temp > 14.75)

}
