% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop.R
\name{set_up}
\alias{set_up}
\title{Sets "semi-globally" the 'up' argument of dreamerr's functions}
\usage{
set_up(.up = 1)
}
\arguments{
\item{.up}{An integer greater or equal to 0.}
}
\description{
When \code{\link[dreamerr]{check_arg}} (or \code{\link[dreamerr]{stop_up}}) is used in non user-level functions, the argument \code{.up} is used to provide an appropriate error message referencing the right function.
}
\details{
To avoid repeating the argument \code{.up} in each \code{check_arg} call, you can set it (kind of) "globally" with \code{set_up}.

The function \code{set_up} does not set the argument \code{up} globally, but only for all calls to \code{check_arg} and \code{check_value} within the same function.
}
\examples{

# Example with computation being made within a non user-level function

sum_fun = function(x, y){
  my_internal(x, y, sum = TRUE)
}

diff_fun = function(x, y){
  my_internal(x, y, sum = FALSE)
}

my_internal = function(x, y, sum){
  set_up(1) # => errors will be at the user-level function
  check_arg(x, y, "numeric scalar mbt")

  # Identical to calling
  # check_arg(x, y, "numeric scalar mbt", .up = 1)

  if(sum) return(x + y)
  return(x - y)
}

# we check it works
sum_fun(5, 6)
diff_fun(5, 6)

# Let's throw some errors
try(sum_fun(5))
try(sum_fun(5, 1:5))

}
