% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{dreamer_plot_prior}
\alias{dreamer_plot_prior}
\title{Plot Prior}
\usage{
dreamer_plot_prior(
  n_samples = 10000,
  probs = c(0.025, 0.975),
  doses,
  n_chains = 1,
  ...,
  times = NULL,
  plot_draws = FALSE,
  alpha = 0.2
)
}
\arguments{
\item{n_samples}{the number of MCMC samples per MCMC chain used to generate
the plot.}

\item{probs}{A vector of length 2 indicating the lower and upper percentiles
to plot.  Not applicable when \code{plot_draws = TRUE}.}

\item{doses}{a vector of doses at which to evaluate and interpolate
between.}

\item{n_chains}{the number of MCMC chains.}

\item{...}{model objects.  See \code{\link[dreamer]{model}} and
examples below.}

\item{times}{a vector of times at which to plot the prior.}

\item{plot_draws}{if \code{TRUE}, the individual draws from the prior are plotted.
If \code{FALSE}, only the prior mean and quantiles are drawn.}

\item{alpha}{the transparency setting for the prior draws in (0, 1].
Only applies if \code{plot_draws = TRUE}.}
}
\value{
The ggplot object.
}
\description{
Plot the prior over the dose range.  This is intended to
help the user choose appropriate priors.
}
\examples{
# Plot prior for one model
set.seed(8111)
dreamer_plot_prior(
 doses = c(0, 2.5, 5),
 mod_quad_binary = model_quad_binary(
   mu_b1 = -.5,
   sigma_b1 = .2,
   mu_b2 = -.5,
   sigma_b2 = .2,
   mu_b3 = .5,
   sigma_b3 = .1,
   link = "logit",
   w_prior = 1
 )
)

# plot individual draws
dreamer_plot_prior(
 doses = seq(from = 0, to = 5, length.out = 50),
 n_samples = 100,
 plot_draws = TRUE,
 mod_quad_binary = model_quad_binary(
   mu_b1 = -.5,
   sigma_b1 = .2,
   mu_b2 = -.5,
   sigma_b2 = .2,
   mu_b3 = .5,
   sigma_b3 = .1,
   link = "logit",
   w_prior = 1
 )
)

# plot prior from mixture of models
dreamer_plot_prior(
 doses = c(0, 2.5, 5),
 mod_linear_binary = model_linear_binary(
   mu_b1 = -1,
   sigma_b1 = .1,
   mu_b2 = 1,
   sigma_b2 = .1,
   link = "logit",
   w_prior = .75
 ),
 mod_quad_binary = model_quad_binary(
   mu_b1 = -.5,
   sigma_b1 = .2,
   mu_b2 = -.5,
   sigma_b2 = .2,
   mu_b3 = .5,
   sigma_b3 = .1,
   link = "logit",
   w_prior = .25
 )
)
}
