% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pruneRepo.R
\name{pruneRepo}
\alias{pruneRepo}
\title{Prune repository from older copies of packages}
\usage{
pruneRepo(repopath = getOption("dratRepo", "~/git/drat"), type = "source",
  pkg, remove = FALSE)
}
\arguments{
\item{repopath}{Character variable with the path to the repo;
defaults to the value of the \dQuote{dratRepo} option with
\dQuote{"~/git/drat"} as fallback}

\item{type}{Character variable for the type of repository, so far \dQuote{source}}

\item{pkg}{Optional character variable specifying a package name, whose
older versions should be pruned. If missing (the default), pruning is
performed on all packages.}

\item{remove}{Logical variable indicating whether files should be removed}
}
\value{
A data frame describing the repository is returned
containing columns with columns \dQuote{file}, \dQuote{package}
(just the name), \dQuote{version} and a logical variable
\dQuote{newest} indicating if the package can be removed.
}
\description{
The function determines which packages in a repositories can be
removed as they are being \sQuote{shadowed} by a newer version of
the same packages.
}
\details{
Given a package name, R will always find the newest version of
that package. Older versions are therefore effectively shadowed
and can be removed without functionally changing a repository.

This function is still undergoing development and polish and may
change in subsequent versions.
}
\author{
Dirk Eddelbuettel
}

