% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deps.R
\name{deps_knitr}
\alias{deps_knitr}
\title{Find the drake dependencies of a dynamic knitr report target.
\lifecycle{stable}}
\usage{
deps_knitr(path)
}
\arguments{
\item{path}{Encoded file path to the \code{knitr}/R Markdown document.
Wrap paths in \code{\link[=file_store]{file_store()}} to encode.}
}
\value{
A data frame of dependencies.
}
\description{
Dependencies in \code{knitr} reports are marked
by \code{\link[=loadd]{loadd()}} and \code{\link[=readd]{readd()}} in active code chunks.
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
load_mtcars_example() # Get the code with drake_example("mtcars").
deps_knitr("report.Rmd")
})
}
}
\seealso{
\code{\link[=deps_code]{deps_code()}}, \code{\link[=deps_target]{deps_target()}}
}
