% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deps.R
\name{deps_code}
\alias{deps_code}
\title{List the dependencies of a function or command
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}}
\usage{
deps_code(x)
}
\arguments{
\item{x}{A function, expression, or text.}
}
\value{
A data frame of the dependencies.
}
\description{
Functions are assumed to be imported,
and language/text are assumed to be commands in a plan.
}
\examples{
# Your workflow likely depends on functions in your workspace.
f <- function(x, y) {
  out <- x + y + g(x)
  saveRDS(out, "out.rds")
}
# Find the dependencies of f. These could be R objects/functions
# in your workspace or packages. Any file names or target names
# will be ignored.
deps_code(f)
# Define a workflow plan data frame that uses your function f().
my_plan <- drake_plan(
  x = 1 + some_object,
  my_target = x + readRDS(file_in("tracked_input_file.rds")),
  return_value = f(x, y, g(z + w))
)
# Get the dependencies of workflow plan commands.
# Here, the dependencies could be R functions/objects from your workspace
# or packages, imported files, or other targets in the workflow plan.
deps_code(my_plan$command[[1]])
deps_code(my_plan$command[[2]])
deps_code(my_plan$command[[3]])
# You can also supply expressions or text.
deps_code(quote(x + y + 123))
deps_code("x + y + 123")
}
\seealso{
\code{\link[=deps_target]{deps_target()}}, \code{\link[=deps_knitr]{deps_knitr()}}
}
