% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{drake_running}
\alias{drake_running}
\title{List running targets.
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}}
\usage{
drake_running(cache = drake::drake_cache(path = path), path = NULL)
}
\arguments{
\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} is ignored.}

\item{path}{Path to a \code{drake} cache
(usually a hidden \verb{.drake/} folder) or \code{NULL}.}
}
\value{
A character vector of target names.
}
\description{
List the targets that either
\enumerate{
\item Are currently being built during a call to \code{\link[=make]{make()}}, or
\item Were in progress when \code{\link[=make]{make()}} was interrupted.
}
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the project, build the targets.
drake_running() # Everything should be done.
# nolint start
# Run make() in one R session...
# slow_plan <- drake_plan(x = Sys.sleep(2))
# make(slow_plan)
# and see the progress in another session.
# drake_running()
# nolint end
}
})
}
}
\seealso{
\code{\link[=drake_done]{drake_done()}}, \code{\link[=drake_failed]{drake_failed()}}, \code{\link[=drake_cancelled]{drake_cancelled()}},
\code{\link[=drake_progress]{drake_progress()}}, \code{\link[=make]{make()}}
}
