% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drake_plan_helpers.R
\name{cancel}
\alias{cancel}
\title{Cancel a target mid-build \lifecycle{experimental}}
\usage{
cancel(allow_missing = TRUE)
}
\arguments{
\item{allow_missing}{Logical. If \code{FALSE}, \code{drake} will not cancel
the target if it is missing from the cache (or if you removed the
key with \code{clean()}).}
}
\value{
Nothing.
}
\description{
Cancel a target mid-build.
Upon cancellation, \code{drake} halts the current target and moves to the
next one. The target's previous value and metadata, if they exist,
remain in the cache.
}
\examples{
\dontrun{
isolate_example("cancel()", {
f <- function(x) {
  cancel()
  Sys.sleep(2) # Does not run.
}
g <- function(x) f(x)
plan <- drake_plan(y = g(1))
make(plan)
# Does not exist.
# readd(y)
})
}
}
\seealso{
cancel_if
}
