% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-testthat.R
\name{test_with_dir}
\alias{test_with_dir}
\title{Run a unit test in a way that quarantines
the side effects from your workspace and file system.}
\usage{
test_with_dir(desc, ...)
}
\arguments{
\item{desc}{Character, description of the test.}

\item{...}{Code to test.}
}
\value{
Nothing.
}
\description{
Typical users of drake should not need this function.
It is exported so it can be used to quarantine the side effects
of the examples in the help files.
}
\examples{
\dontrun{
test_with_dir(
  "Write a file to a temporary folder",
  writeLines("hello", "world.txt")
)
file.exists("world.txt") # FALSE
}
}
\keyword{internal}
