% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-examples.R
\name{drake_examples}
\alias{drake_examples}
\title{List the names of all the drake examples.}
\usage{
drake_examples(quiet = TRUE)
}
\arguments{
\item{quiet}{Logical, passed to \code{downloader::download()}
and thus \code{utils::download.file()}. Whether
to download quietly or print progress.}
}
\value{
Names of all the drake examples.
}
\description{
You can find the code files of the examples at
\url{https://github.com/wlandau/drake-examples}.
The \code{drake_examples()} function downloads the list of examples
from \url{https://wlandau.github.io/drake-examples/examples.md},
so you need an internet connection.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
if (requireNamespace("downloader")) {
drake_examples() # List all the drake examples.
# Sets up the example from
# https://ropenscilabs.github.io/drake-manual/mtcars.html
drake_example("mtcars")
# Sets up the SLURM example.
drake_example("slurm")
}
})
}
}
\seealso{
\code{\link[=drake_example]{drake_example()}}, \code{\link[=make]{make()}}
}
