% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hooks.R
\name{empty_hook}
\alias{empty_hook}
\title{A \code{hook} argument to \code{\link[=make]{make()}}
for which no targets get built and no imports get processed.}
\usage{
empty_hook(code)
}
\arguments{
\item{code}{Placeholder for the code to build a target/import.
For \code{empty_hook()}, this code does not actually get executed.}
}
\value{
A function that you can supply to the \code{hook} argument
of \code{\link[=make]{make()}}.
}
\description{
This hook forces \code{\link[=make]{make()}}
to essentially do nothing.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_basic_example() # Get the code with drake_example("basic").
# Run the project with the empty hook.
make(my_plan, hook = empty_hook) # Nothing gets built!
cached() # character(0) # nolint
})
}
}
