% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hash.R
\name{short_hash}
\alias{short_hash}
\title{Get the short hash algorithm of a drake cache.}
\usage{
short_hash(cache = drake::get_cache(verbose = verbose), verbose = verbose)
}
\arguments{
\item{cache}{drake cache}

\item{verbose}{whether to print console messages}
}
\value{
A character vector naming a hash algorithm.
}
\description{
See the advanced storage tutorial
at \url{https://ropensci.github.io/drake/articles/storage.html}
for details.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_basic_example() # Get the code with drake_example("basic").
# Run the project and return the internal master configuration list.
config <- make(my_plan)
# Locate the storr cache.
cache <- config$cache
# Get the short hash algorithm of the cache.
short_hash(cache)
})
}
}
\seealso{
\code{\link{default_short_hash_algo}},
\code{\link{default_long_hash_algo}}
}
