% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hash.R
\name{long_hash}
\alias{long_hash}
\title{Get the long hash algorithm of a drake cache.}
\usage{
long_hash(cache = drake::get_cache(verbose = verbose), verbose = TRUE)
}
\arguments{
\item{cache}{drake cache}

\item{verbose}{whether to print console messages}
}
\value{
A character vector naming a hash algorithm.
}
\description{
See the advanced storage tutorial
at \url{https://ropensci.github.io/drake/articles/storage.html}
for details.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_basic_example() # Get the code with drake_example("basic").
# Run the project and return the internal master configuration list.
config <- make(my_plan)
# Locate the storr cache.
cache <- config$cache
# Get the long hash algorithm of the cache.
long_hash(cache)
})
}
}
\seealso{
\code{\link{default_short_hash_algo}},
\code{\link{default_long_hash_algo}}
}
