% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.R
\name{drake_meta}
\alias{drake_meta}
\title{Compute the metadata of a target or import.}
\usage{
drake_meta(target, config)
}
\arguments{
\item{target}{Character scalar, name of the target
to get metadata.}

\item{config}{Master internal configuration list produced
by \code{\link{drake_config}()}.}
}
\value{
A list of metadata on a target. Does not include
the file modification time if the target is a file.
That piece is provided later in \code{\link{make}()} by
\code{drake:::finish_meta}.
}
\description{
The metadata helps determine if the
target is up to date or outdated. The metadata of imports
is used to compute the metadata of targets.
}
\details{
Target metadata is computed
with \code{drake_meta()} and then
\code{drake:::finish_meta()}.
This metadata corresponds
to the state of the target immediately after it was built
or imported in the last \code{\link{make}()} that
did not skip it.
The exception to this is the \code{$missing} element
of the metadata, which indicates if the target/import
was missing just \emph{before} it was built.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
# This example is not really a user-side demonstration.
# It just walks through a dive into the internals.
# Populate your workspace and write 'report.Rmd'.
load_basic_example() # Get the code with drake_example("basic").
# Create the master internal configuration list.
config <- drake_config(my_plan)
# Optionally, compute metadata on 'small',
# including a hash/fingerprint
# of the dependencies. If meta is not supplied,
# drake_build() computes it automatically.
meta <- drake_meta(target = "small", config = config)
# Should not yet include 'small'.
cached()
# Build 'small'.
# Equivalent to just drake_build(target = "small", config = config).
drake_build(target = "small", config = config, meta = meta)
# Should now include 'small'
cached()
readd(small)
})
}
}
\seealso{
\code{\link{dependency_profile}}, \code{\link{make}}
}
