% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose.R
\name{diagnose}
\alias{diagnose}
\title{Function \code{diagnose}}
\usage{
diagnose(target = NULL, character_only = FALSE, path = getwd(),
  search = TRUE, cache = drake::get_cache(path = path, search = search,
  verbose = verbose), verbose = TRUE)
}
\arguments{
\item{target}{name of the target of the error to get.
Can be a symbol if \code{character_only} is \code{FALSE},
must be a character if \code{character_only} is \code{TRUE}.}

\item{character_only}{logical, whether \code{target} should be treated
as a character or a symbol.
Just like \code{character.only} in \code{library()}.}

\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.}

\item{search}{If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.}

\item{cache}{optional drake cache. See code{\link{new_cache}()}.
If \code{cache} is supplied,
the \code{path} and \code{search} arguments are ignored.}

\item{verbose}{whether to print console messages}
}
\description{
Get the last stored error of a target
that failed to build. This target could be a
completely failed target or a target
that failed initially, retried, then succeeded.
If no target is given, then \code{diagnose()} simply
lists the targets for which a error is retrievable.
Together, functions \code{\link{failed}()} and
\code{diagnose()} should eliminate the strict need
for ordinary error messages printed to the console.
}
\examples{
\dontrun{
diagnose()
f <- function(){
  stop("unusual error")
}
bad_plan <- workplan(my_target = f())
make(bad_plan)
failed() # from the last make() only
diagnose() # from all previous make()'s
error <- diagnose(my_target)
str(error)
error$calls # View the traceback.
}
}
\seealso{
\code{\link{failed}}, \code{\link{progress}},
\code{\link{readd}}, \code{\link{workplan}}, \code{\link{make}}
}
