% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{config}
\alias{config}
\title{Function config}
\usage{
config(plan = workplan(), targets = drake::possible_targets(plan),
  envir = parent.frame(), verbose = TRUE, hook = function(code) {    
  force(code) }, cache = drake::get_cache(verbose = verbose),
  parallelism = drake::default_parallelism(), jobs = 1,
  packages = rev(.packages()), prework = character(0),
  prepend = character(0), command = drake::default_Makefile_command(),
  args = drake::default_Makefile_args(jobs = jobs, verbose = verbose),
  recipe_command = drake::default_recipe_command(), timeout = Inf,
  cpu = timeout, elapsed = timeout, retries = 0, clear_progress = FALSE,
  graph = NULL)
}
\arguments{
\item{plan}{same as for \code{\link{make}}}

\item{targets}{same as for \code{\link{make}}}

\item{envir}{same as for \code{\link{make}}}

\item{verbose}{same as for \code{\link{make}}}

\item{hook}{same as for \code{\link{make}}}

\item{cache}{same as for \code{\link{make}}}

\item{parallelism}{same as for \code{\link{make}}}

\item{jobs}{same as for \code{\link{make}}}

\item{packages}{same as for \code{\link{make}}}

\item{prework}{same as for \code{\link{make}}}

\item{prepend}{same as for \code{\link{make}}}

\item{command}{same as for \code{\link{make}}}

\item{args}{same as for \code{\link{make}}}

\item{recipe_command}{same as for \code{\link{make}}}

\item{timeout}{same as for \code{\link{make}}}

\item{cpu}{same as for \code{\link{make}}}

\item{elapsed}{same as for \code{\link{make}}}

\item{retries}{same as for \code{\link{make}}}

\item{clear_progress}{logical, whether to clear
the cached progress of the targets readable by}

\item{graph}{igraph object representing the workflow plan network
\code{\link{progress}()}}
}
\description{
Compute the internal runtime parameter list of
\code{\link{make}()}. This could save time if you are planning
multiple function calls of functions like \code{\link{outdated}()}
or \code{\link{plot_graph}()}. Drake needs to import and cache files
and objects to compute the configuration list, which in turn
supports user-side functions to help with visualization and parallelism.
The result differs from
\code{\link{make}(..., imports_only = TRUE)}
in that the graph includes both the targets and the imports,
not just the imports.
}
\examples{
\dontrun{
load_basic_example()
con <- config(my_plan)
outdated(my_plan, config = con)
missed(my_plan, config = con)
max_useful_jobs(my_plan, config = con)
plot_graph(my_plan, config = con)
dataframes_graph(my_plan, config = con)
}
}
\seealso{
\code{\link{workplan}}, \code{\link{make}}, \code{\link{plot_graph}}
}
