% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{plot.dr4pl}
\alias{plot.dr4pl}
\title{Make a plot of a 4PL model curve and data}
\usage{
\method{plot}{dr4pl}(x, type.curve = "all",
  text.title = "Dose-response plot", text.x = "Dose", text.y = "Response",
  indices.outlier = NULL, breaks.x = NULL, breaks.y = NULL, ...)
}
\arguments{
\item{x}{`dr4pl' object whose data and mean response function will be plotted.}

\item{type.curve}{Indicator of the type of a dose-response curve. "all" indicates
that data and a curve will be plotted while "data" indicates that only data
will be plotted.}

\item{text.title}{Character string for the title of a plot with a default set to 
"Dose response plot".}

\item{text.x}{Character string for the x-axis of the plot with a default set to 
"Dose".}

\item{text.y}{Character string for the y-axis of the plot with a default set to 
"Response".}

\item{indices.outlier}{Pass a vector indicating all indices which are outliers in 
the data.}

\item{breaks.x}{Vector of desired break points for the x-axis}

\item{breaks.y}{Vector of desired break points for the y-axis}

\item{...}{All arguments that can normally be passed to ggplot.}
}
\description{
This function displays a dose-response curve and data. As a default,
the x-axis represents dose levels in log 10 scale and the y-axis represents
responses. The black solid line represents a dose-response curve. The blue filled
circles represent data points and red triangles represent outliers.
}
\examples{
ryegrass.dr4pl <- dr4pl::dr4pl(Response ~ Dose, data = sample_data_1)

plot(ryegrass.dr4pl)

##Able to further edit plots
library(ggplot2) #needed to change color to green
ryegrass.dr4pl <- dr4pl::dr4pl(Response ~ Dose, 
                               data = sample_data_1, 
                               text.title = "Sample Data Plot")

a <- plot(ryegrass.dr4pl) 
a + geom_point(color = "green", size = 5)

##Bring attention to outliers using parameter indices.outlier.

a <- dr4pl(Response ~ Dose, 
           data = drc_error_3, 
           method.init = "Mead", 
           method.robust = "absolute" )
plot(a, indices.outlier = c(90, 101))

##Change the plot title default with parameter text.title

ryegrass.dr4pl <- dr4pl::dr4pl(Response ~ Dose, 
                               data = sample_data_1)
plot(ryegrass.dr4pl, text.title = "My New Dose Response plot")

##Change the labels of the x and y axis to your need

library(drc) #needed to load 'decontaminants' data set
d <- subset(decontaminants, group \%in\% "hpc")
e <- dr4pl(count~conc, data = d)
plot(e, 
     text.title = "hpc Decontaminants Plot", 
     text.x = "Concentration", 
     text.y = "Count")

}
\author{
Hyowon An, Justin T. Landis and Aubrey G. Bailey
}
