% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dq_busy.R
\name{dq_busy}
\alias{dq_busy}
\title{Adds a loading image if shiny is busy}
\usage{
dq_busy(icon_path = NULL, time = 500, animation = "fadeIn")
}
\arguments{
\item{icon_path}{optional character, icon source path}

\item{time}{optional integer indicating the animation time of the loader.
Can be useful to omit loader for many short loading moments, but show it if
calculation really needs some time. Set to 0 to disable animations.}

\item{animation}{optional character specifying the animation of the loader}
}
\value{
shiny tag holding the icon
}
\description{
Adds a loading image to the page which is visible when shiny is
busy.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
shinyApp(
  ui = fluidPage(
    dq_busy(time = 1500),
    actionButton("button", "make me busy")
  ),
  server = function(input, output) {
    observeEvent(input$button, Sys.sleep(3))
  }
)

}
}
\author{
richard.kunze
}
