% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/dqset.seed.R
\name{dqRNGkind}
\alias{dqRNGkind}
\alias{dqrunif}
\alias{dqrnorm}
\alias{dqrexp}
\alias{dqset.seed}
\title{R interface}
\usage{
dqRNGkind(kind, normal_kind = "ignored")

dqrunif(n, min = 0, max = 1)

dqrnorm(n, mean = 0, sd = 1)

dqrexp(n, rate = 1)

dqset.seed(seed)
}
\arguments{
\item{kind}{string specifying the RNG (see details)}

\item{normal_kind}{ignored; included for compatibility with \code{\link{RNGkind}}}

\item{n}{number of  observations}

\item{min}{lower limit of the uniform distribution}

\item{max}{upper limit of the uniform distribution}

\item{mean}{mean value of the normal distribution}

\item{sd}{standard deviation of the normal distribution}

\item{rate}{rate of the exponential distribution}

\item{seed}{integer scalar to seed the random number generator, or an integer vector of length 2 representing a 64-bit seed.}
}
\value{
\code{dqrunif}, \code{dqrnorm}, and \code{dqrexp} return a numeric vector of length \code{n}.
}
\description{
The \code{dqrng} package provides several fast random number
  generators together with fast functions for generating random numbers
  according to a uniform, normal and exponential distribution. These
  functions are modeled after the \code{base} functions
  \code{\link{set.seed}}, \code{\link{RNGkind}}, \code{\link{runif}},
  \code{\link{rnorm}}, and \code{\link{rexp}}.
}
\details{
Supported RNG kinds:
\describe{
  \item{pcg64}{The default 64 bit variant from the PCG family developed by
   Melissa O'Neill. See \url{http://www.pcg-random.org} for more details.}
  \item{Xoroshiro128+ and Xoshiro256+}{RNGs developed by David Blackman and
   Sebastiano Vigna. They are used as default RNGs in Erlang and Lua. See
    \url{http://xoshiro.di.unimi.it/} for more details.}
  \item{Threefry}{The 64 bit version of the 20 rounds Threefry engine as
   provided by \code{\link[sitmo]{sitmo-package}}}
}

Xoroshiro128+ is the default since it is the fastest generator provided by
this package.

The functions \code{dqrnorm} and \code{dqrexp} use the Ziggurat algorithm as
provided by \code{boost.random}.

See \code{\link{generateSeedVectors}} for rapid generation of integer-vector
seeds that provide 64 bits of entropy. These allow full exploration of
the state space of the 64-bit RNGs provided in this package.
}
\examples{
library(dqrng)

# Set custom RNG.
dqRNGkind("Xoshiro256+")

# Use an integer scalar to set a seed.
dqset.seed(42)

# Use an integer vector to set a seed.
dqset.seed(c(31311L, 24123423L))

# Random sampling from distributions.
dqrunif(5, min = 2, max = 10)
dqrexp(5, rate = 4)
dqrnorm(5, mean = 5, sd = 3)
}
\seealso{
\code{\link{set.seed}}, \code{\link{RNGkind}}, \code{\link{runif}},
         \code{\link{rnorm}}, and \code{\link{rexp}}
}
