% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidiers.R
\name{tidy.dpm}
\alias{tidy.dpm}
\alias{glance.dpm}
\title{Tidy methods for dpm}
\usage{
\method{tidy}{dpm}(x, conf.int = FALSE, conf.level = 0.95, ...)

\method{glance}{dpm}(x, ...)
}
\arguments{
\item{x}{A \code{dpm} object.}

\item{conf.int}{Logical indicating whether or not to include a confidence
interval in the tidy data frame.}

\item{conf.level}{The confidence level to use for the confidence interval
when \code{conf.int} is TRUE. Default is .95, corresponding to a 95\% confidence
interval.}

\item{...}{Other arguments passed to \link[dpm]{summary.dpm}.}
}
\value{
A tibble::tibble() with information about model components. These will be
coefficient estimates (for \code{tidy()}) or model fit (for \code{glance()}),
following the naming standards established by the \pkg{broom} package.
}
\description{
\code{dpm} objects support the \pkg{broom} package's \code{tidy} method.
}
\examples{
if (requireNamespace("broom")) {
  library(broom)
  # Load example data
  data("WageData", package = "panelr")
  # Convert data to panel_data format for ease of use
  wages <- panel_data(WageData, id = id, wave = t)

  fit <- dpm(wks ~ pre(lag(union)) + lag(lwage) | ed, data = wages)
  tidy(fit)
}
}
