% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join-cross.R
\name{cross_join}
\alias{cross_join}
\title{Cross join}
\usage{
cross_join(x, y, ..., copy = FALSE, suffix = c(".x", ".y"))
}
\arguments{
\item{x, y}{A pair of data frames, data frame extensions (e.g. a tibble), or
lazy data frames (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{Other parameters passed onto methods.}

\item{copy}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into the
same src as \code{x}.  This allows you to join tables across srcs, but
it is a potentially expensive operation so you must opt into it.}

\item{suffix}{If there are non-joined duplicate variables in \code{x} and
\code{y}, these suffixes will be added to the output to disambiguate them.
Should be a character vector of length 2.}
}
\value{
An object of the same type as \code{x} (including the same groups). The output has
the following properties:
\itemize{
\item There are \code{nrow(x) * nrow(y)} rows returned.
\item Output columns include all columns from both \code{x} and \code{y}. Column name
collisions are resolved using \code{suffix}.
\item The order of the rows and columns of \code{x} is preserved as much as possible.
}
}
\description{
Cross joins match each row in \code{x} to every row in \code{y}, resulting in a data
frame with \code{nrow(x) * nrow(y)} rows.

Since cross joins result in all possible matches between \code{x} and \code{y}, they
technically serve as the basis for all \link[=mutate-joins]{mutating joins}, which
can generally be thought of as cross joins followed by a filter. In practice,
a more specialized procedure is used for better performance.
}
\section{Methods}{

This function is a \strong{generic}, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.

The following methods are currently available in loaded packages:
\Sexpr[stage=render,results=rd]{dplyr:::methods_rd("cross_join")}.
}

\examples{
# Cross joins match each row in `x` to every row in `y`.
# Data within the columns is not used in the matching process.
cross_join(band_instruments, band_members)

# Control the suffix added to variables duplicated in
# `x` and `y` with `suffix`.
cross_join(band_instruments, band_members, suffix = c("", "_y"))
}
\seealso{
Other joins: 
\code{\link{filter-joins}},
\code{\link{mutate-joins}},
\code{\link{nest_join}()}
}
\concept{joins}
