% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colwise-arrange.R
\name{arrange_all}
\alias{arrange_all}
\alias{arrange_at}
\alias{arrange_if}
\title{Arrange rows by a selection of variables}
\usage{
arrange_all(.tbl, .funs = list(), ..., .by_group = FALSE)

arrange_at(.tbl, .vars, .funs = list(), ..., .by_group = FALSE)

arrange_if(.tbl, .predicate, .funs = list(), ..., .by_group = FALSE)
}
\arguments{
\item{.tbl}{A \code{tbl} object.}

\item{.funs}{A function \code{fun}, a quosure style lambda \code{~ fun(.)} or a list of either form.}

\item{...}{Additional arguments for the function calls in
\code{.funs}. These are evaluated only once, with \link[rlang:tidy-dots]{tidy dots} support.}

\item{.by_group}{If \code{TRUE}, will sort first by grouping variable. Applies to
grouped data frames only.}

\item{.vars}{A list of columns generated by \code{\link[=vars]{vars()}},
a character vector of column names, a numeric vector of column
positions, or \code{NULL}.}

\item{.predicate}{A predicate function to be applied to the columns
or a logical vector. The variables for which \code{.predicate} is or
returns \code{TRUE} are selected. This argument is passed to
\code{\link[rlang:as_function]{rlang::as_function()}} and thus supports quosure-style lambda
functions and strings representing function names.}
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("superseded")}

Scoped verbs (\verb{_if}, \verb{_at}, \verb{_all}) have been superseded by the use of
\code{\link[=across]{across()}} in an existing verb. See \code{vignette("colwise")} for details.

These \link{scoped} variants of \code{\link[=arrange]{arrange()}} sort a data frame by a
selection of variables. Like \code{\link[=arrange]{arrange()}}, you can modify the
variables before ordering with the \code{.funs} argument.
}
\section{Grouping variables}{


The grouping variables that are part of the selection participate
in the sorting of the data frame.
}

\examples{
df <- as_tibble(mtcars)
arrange_all(df)
# ->
arrange(df, across())

arrange_all(df, desc)
# ->
arrange(df, across(everything(), desc))
}
