% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colwise.R
\name{summarise_all}
\alias{mutate_all}
\alias{mutate_at}
\alias{mutate_each_q}
\alias{mutate_if}
\alias{summarise_all}
\alias{summarise_at}
\alias{summarise_each_q}
\alias{summarise_if}
\alias{summarize_all}
\alias{summarize_at}
\alias{summarize_if}
\title{Summarise and mutate multiple columns.}
\usage{
summarise_all(.tbl, .funs, ...)

mutate_all(.tbl, .funs, ...)

summarise_if(.tbl, .predicate, .funs, ...)

mutate_if(.tbl, .predicate, .funs, ...)

summarise_at(.tbl, .cols, .funs, ...)

mutate_at(.tbl, .cols, .funs, ...)

summarize_all(.tbl, .funs, ...)

summarize_at(.tbl, .cols, .funs, ...)

summarize_if(.tbl, .predicate, .funs, ...)
}
\arguments{
\item{.tbl}{a tbl}

\item{.funs}{List of function calls generated by
\code{\link{funs}()}, or a character vector of function names, or
simply a function (only for local sources).}

\item{...}{Additional arguments for the function calls. These are
evaluated only once.}

\item{.predicate}{A predicate function to be applied to the columns
or a logical vector. The columns for which \code{.predicate} is
or returns \code{TRUE} will be summarised or mutated.}

\item{.cols}{A list of columns generated by \code{\link{vars}()},
or a character vector of column names, or a numeric vector of column
positions.}
}
\value{
A data frame. By default, the newly created columns have the shortest
  names needed to distinguish the output. To force inclusion of a name,
  even when not needed, name the input (see examples for details).
}
\description{
\code{summarise_all()} and \code{mutate_all()} apply the functions
to all (non-grouping) columns. \code{summarise_at()} and
\code{mutate_at()} allow you to select columns
using the same name-based \code{\link{select_helpers}} as with
\code{\link{select}()}. \code{summarise_if}() and
\code{mutate_if}() operate on columns for which a predicate returns
\code{TRUE}. Finally, \code{\link{summarise_each}()} and
\code{\link{mutate_each}()} are older variants that will be
deprecated in the future.
}
\examples{
by_species <- iris \%>\% group_by(Species)

# One function
by_species \%>\% summarise_all(n_distinct)
by_species \%>\% summarise_all(mean)

# Use the _at and _if variants for conditional mapping.
by_species \%>\% summarise_if(is.numeric, mean)

# summarise_at() can use select() helpers with the vars() function:
by_species \%>\% summarise_at(vars(Petal.Width), mean)
by_species \%>\% summarise_at(vars(matches("Width")), mean)

# You can also specify columns with column names or column positions:
by_species \%>\% summarise_at(c("Sepal.Width", "Petal.Width"), mean)
by_species \%>\% summarise_at(c(1, 3), mean)

# You can provide additional arguments. Those are evaluated only once:
by_species \%>\% summarise_all(mean, trim = 1)
by_species \%>\% summarise_at(vars(Petal.Width), mean, trim = 1)

# You can provide an expression or multiple functions with the funs() helper.
by_species \%>\% mutate_all(funs(. * 0.4))
by_species \%>\% summarise_all(funs(min, max))
# Note that output variable name must now include function name, in order to
# keep things distinct.

# Function names will be included if .funs has names or whenever multiple
# functions are used.
by_species \%>\% mutate_all(funs("in" = . / 2.54))
by_species \%>\% mutate_all(funs(rg = diff(range(.))))
by_species \%>\% summarise_all(funs(med = median))
by_species \%>\% summarise_all(funs(Q3 = quantile), probs = 0.75)
by_species \%>\% summarise_all(c("min", "max"))

# Two functions, continued
by_species \%>\% summarise_at(vars(Petal.Width, Sepal.Width), funs(min, max))
by_species \%>\% summarise_at(vars(matches("Width")), funs(min, max))

}
\seealso{
\code{\link{vars}()}, \code{\link{funs}()}
}

