% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl-df.r
\name{join.tbl_df}
\alias{anti_join.tbl_df}
\alias{full_join.tbl_df}
\alias{inner_join.tbl_df}
\alias{join.tbl_df}
\alias{left_join.tbl_df}
\alias{right_join.tbl_df}
\alias{semi_join.tbl_df}
\title{Join data frame tbls.}
\usage{
\method{inner_join}{tbl_df}(x, y, by = NULL, copy = FALSE,
  suffix = c(".x", ".y"), ...)

\method{left_join}{tbl_df}(x, y, by = NULL, copy = FALSE, suffix = c(".x",
  ".y"), ...)

\method{right_join}{tbl_df}(x, y, by = NULL, copy = FALSE,
  suffix = c(".x", ".y"), ...)

\method{full_join}{tbl_df}(x, y, by = NULL, copy = FALSE, suffix = c(".x",
  ".y"), ...)

\method{semi_join}{tbl_df}(x, y, by = NULL, copy = FALSE, ...)

\method{anti_join}{tbl_df}(x, y, by = NULL, copy = FALSE, ...)
}
\arguments{
\item{x}{tbls to join}

\item{y}{tbls to join}

\item{by}{a character vector of variables to join by.  If \code{NULL}, the
  default, \code{join} will do a natural join, using all variables with
  common names across the two tables. A message lists the variables so
  that you can check they're right (to suppress the message, simply
  explicitly list the variables that you want to join).

  To join by different variables on x and y use a named vector.
  For example, \code{by = c("a" = "b")} will match \code{x.a} to
  \code{y.b}.}

\item{copy}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into the
same src as \code{x}.  This allows you to join tables across srcs, but
it is a potentially expensive operation so you must opt into it.}

\item{suffix}{If there are non-joined duplicate variables in \code{x} and
\code{y}, these suffixes will be added to the output to diambiguate them.}

\item{...}{included for compatibility with the generic; otherwise ignored.}
}
\description{
See \code{\link{join}} for a description of the general purpose of the
functions.
}
\examples{
if (require("Lahman")) {
batting_df <- tbl_df(Batting)
person_df <- tbl_df(Master)

uperson_df <- tbl_df(Master[!duplicated(Master$playerID), ])

# Inner join: match batting and person data
inner_join(batting_df, person_df)
inner_join(batting_df, uperson_df)

# Left join: match, but preserve batting data
left_join(batting_df, uperson_df)

# Anti join: find batters without person data
anti_join(batting_df, person_df)
# or people who didn't bat
anti_join(person_df, batting_df)
}
}

