% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tally.R
\name{tally}
\alias{count}
\alias{count_}
\alias{tally}
\title{Counts/tally observations by group.}
\usage{
tally(x, wt, sort = FALSE)

count(x, ..., wt = NULL, sort = FALSE)

count_(x, vars, wt = NULL, sort = FALSE)
}
\arguments{
\item{x}{a \code{\link{tbl}} to tally/count.}

\item{wt}{(Optional) If not specified, will tally the number of rows.
If specified, will perform a "weighted" tally but summing over the
specified variable.}

\item{sort}{if \code{TRUE} will sort output in descending order of \code{n}}

\item{...,vars}{Variables to group by.}
}
\description{
\code{tally} is a convenient wrapper for summarise that will either call
\code{\link{n}} or \code{\link{sum}(n)} depending on whether you're tallying
for the first time, or re-tallying. \code{count()} is similar, but also
does the \code{\link{group_by}} for you.
}
\examples{
if (require("Lahman")) {
batting_tbl <- tbl_df(Batting)
tally(group_by(batting_tbl, yearID))
tally(group_by(batting_tbl, yearID), sort = TRUE)

# Multiple tallys progressively roll up the groups
plays_by_year <- tally(group_by(batting_tbl, playerID, stint), sort = TRUE)
tally(plays_by_year, sort = TRUE)
tally(tally(plays_by_year))

# This looks a little nicer if you use the infix \%>\% operator
batting_tbl \%>\% group_by(playerID) \%>\% tally(sort = TRUE)

# count is even more succinct - it also does the grouping for you
batting_tbl \%>\% count(playerID)
batting_tbl \%>\% count(playerID, wt = G)
batting_tbl \%>\% count(playerID, wt = G, sort = TRUE)
}
}

