% Generated by roxygen2 (4.0.1): do not edit by hand
\name{summarise_each}
\alias{mutate_each}
\alias{mutate_each_q}
\alias{summarise_each}
\alias{summarise_each_q}
\title{Summarise and mutate multiple columns.}
\usage{
summarise_each(tbl, funs, ...)

summarise_each_q(tbl, funs, vars, env = parent.frame())

mutate_each(tbl, funs, ...)

mutate_each_q(tbl, funs, vars, env = parent.frame())
}
\arguments{
\item{tbl}{a tbl}

\item{funs}{List of function calls, generated by \code{\link{funs}}, or
a character vector of function names.}

\item{vars,...}{Variables to include/exclude in mutate/summarise.
  You can use same specifications as in \code{\link{select}}.

  For standard evaluation versions (ending in \code{_q}) these can
  be either a list of expressions or a character vector.}

\item{env}{The environment in which to evaluate the function calls.
Should only be modified by advanced users.}
}
\description{
Apply one or more functions to one or more columns. Grouping variables
are always excluded from modification.
}
\examples{
# One function
by_species <- iris \%>\% group_by(Species)
by_species \%>\% summarise_each(funs(length))
by_species \%>\% summarise_each(funs(mean))
by_species \%>\% summarise_each(funs(mean), Petal.Width)
by_species \%>\% summarise_each(funs(mean), matches("Width"))

by_species \%>\% mutate_each(funs(half = . / 2))
by_species \%>\% mutate_each(funs(min_rank))

# Two functions
by_species \%>\% summarise_each(funs(min, max))
by_species \%>\% summarise_each(funs(min, max), Petal.Width, Sepal.Width)
by_species \%>\% summarise_each(funs(min, max), matches("Width"))

# Alternative function specification
iris \%>\% summarise_each(funs(ul = length(unique(.))))
by_species \%>\% summarise_each(funs(ul = length(unique(.))))

by_species \%>\% summarise_each(c("min", "max"))

# Alternative variable specification
summarise_each_q(iris, funs(max), names(iris)[-5])
summarise_each_q(iris, funs(max), list(quote(-Species)))
}

