% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dcCA_CWM_SNC.R
\name{plot_dcCA_CWM_SNC}
\alias{plot_dcCA_CWM_SNC}
\title{Plot the CWMs and SNCs of a single dc-CA axis.}
\usage{
plot_dcCA_CWM_SNC(
  x,
  axis = 1,
  envfactor = NULL,
  traitfactor = NULL,
  facet = TRUE,
  newnames = NULL,
  remove_centroids = FALSE,
  with_lines = TRUE,
  getPlotdata2plotdCCA = NULL
)
}
\arguments{
\item{x}{results from \code{\link{dc_CA}} of class \code{dcca}.}

\item{axis}{the axis number to get (default 1).}

\item{envfactor}{name of row factor to display as color and lines in the CWM
plot (default \code{NULL}). The default extracts the factor from the 
environmental model. If set to \code{NA}, no additional coloring and lines
are displayed in \code{\link{plot.dcca}}. The parameter sets the 
\code{groups} variable in the \code{CWM_SNC} data frame of the return 
value/in the plot.}

\item{traitfactor}{name of column factor to display as color and lines in
the SNC plot (default \code{NULL}). The default extracts the factor from
the trait model. If set to \code{NA}, no additional coloring and lines are
displayed in \code{\link{plot.dcca}}. The parameter sets the \code{groups} 
variable in the \code{CWM_SNC} data frame of the return value/in the plot.}

\item{facet}{logical. Default \code{TRUE} for CWMs and SNCs plots in 
separate panels. This parameter changes the position of the centroid names
(from left to right for the environmental centroids). If \code{facet = TRUE}
and \code{with_lines = TRUE}, the line fits ignore groups of species and 
of sites.}

\item{newnames}{a list  with two elements: names for traits and for 
environmental variables, default \code{NULL} for names derived from the 
result of \code{\link{scores.dcca}} with \code{tidy = TRUE}.}

\item{remove_centroids}{logical to remove any centroids from the plot data 
(default \code{FALSE}). Can be a two-vector, \emph{e.g.} 
\code{c(TRUE, FALSE)} to remove only the environmental centroids.}

\item{with_lines}{logical. Default \code{TRUE} for straight lines through 
groups of points. \code{traitfactor = NA} and \code{envfactor = NA}. 
Centroids are not displayed in this case.}

\item{getPlotdata2plotdCCA}{the results of an \code{\link{getPlotdata}}. 
Default \code{NULL}.}
}
\value{
a ggplot object
}
\description{
\code{plot_dcCA_CWM_SNC} plots the CWMs and SNCs of a dc-CA axis against 
this axis, with optional centroids and colors for groups of sites and/or 
species if available in the data.
}
\details{
The argument \code{getPlotdata2plotdCCA} is to allow some modifications of
the data frame resulting from \code{\link{getPlotdata}}. The variable names
and score levels should remain untouched. \code{plot_dcCA_CWM_SNC} uses the
variables: \code{dcCA}\emph{k} with axis number \emph{k} and
\code{"CWM-SNC", "groups", "points", "sizeweight"} for the y-axis, coloring, 
shape and size of items, respectively.

The function is used in \code{\link{plot.dcca}}.
}
\examples{
data("dune_trait_env")

# rownames are carried forward in results
rownames(dune_trait_env$comm) <- dune_trait_env$comm$Sites

# must delete "Sites" from response matrix or data frame
Y <- dune_trait_env$comm[, -1] # must delete "Sites"

out <- dc_CA(formulaEnv = ~ A1 + Moist + Use + Manure + Condition(Mag),
             formulaTraits = ~ SLA + Height + LDMC + Seedmass + Lifespan,
             response = Y,
             dataEnv = dune_trait_env$envir,
             dataTraits = dune_trait_env$traits,
             verbose = FALSE)

plot_dcCA_CWM_SNC(out, facet = FALSE)

}
