% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relabel_predictors.R
\name{relabel_predictors}
\alias{relabel_predictors}
\title{Relabel the Predictors in a Tidy Data Frame of Regression Results}
\usage{
relabel_predictors(x, ...)
}
\arguments{
\item{x}{Either a tidy data frame to be passed to \code{\link[dotwhisker]{dwplot}} or a plot generated by \code{\link[dotwhisker]{dwplot}}}

\item{...}{Named replacements, as in \code{\link[dplyr]{recode}}. The argument names should be the current values to be replaced, and the argument values should be the new (replacement) values.  For backwards compatibility, a named character vector, with new values as values, and old values as names may also be used.  The order of the named replacements will be preserved, so this function also serves the purpose of reordering variables.}
}
\value{
The function returns an object of the same type as it is passed: a tidy data frame or a plot generated by \code{\link[dotwhisker]{dwplot}}.
}
\description{
\code{relabel_predictors} is a convenience function for relabeling the predictors in a tidy data frame to be passed to \code{\link[dotwhisker]{dwplot}} or a plot generated by \code{\link[dotwhisker]{dwplot}}
}
\examples{
library(broom)
library(dplyr)

data(mtcars)
m1 <- lm(mpg ~ wt + cyl + disp, data = mtcars)
m1_df <- broom::tidy(m1) \%>\%
         relabel_predictors("(Intercept)" = "Intercept",
                              wt = "Weight",
                              disp = "Displacement",
                              cyl = "Cylinder")
dwplot(m1_df)

dwplot(m1, show_intercept = TRUE) \%>\%
    relabel_predictors("(Intercept)" = "Intercept",
                              wt = "Weight",
                              disp = "Displacement",
                              cyl = "Cylinder")


}
