% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domir.r
\name{print.domir}
\alias{print.domir}
\title{Print method for \code{domir}}
\usage{
\method{print}{domir}(x, ...)
}
\arguments{
\item{x}{an object of class "domir".}

\item{...}{further arguments passed to \code{\link{print.default}}.}
}
\value{
The submitted "domir" object, invisibly.
}
\description{
Reports formatted results from \code{domir} class object.
}
\details{
The print method for class \code{domir} objects reports out the
following results:
\itemize{
\item{Value when all elements are included in \code{obj}.}
\item{Value for the elements included in \code{.all} if any.}
\item{Value for the elements included in \code{.adj} if any.}
\item{Matrix describing general dominance values, standardized
general dominance values, and the ranking of the general
dominance values.}
\item{Matrix describing the conditional dominance values; when computed}
\item{Matrix describing the complete dominance designations; when
determined}
\item{If following \code{summary.domir}, matrix describing the strongest
dominance designations between all elements.}}

The \code{domir} print method alters dimension names for readability and they
do not display as stored in the \code{domir} object.
}
