# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' rcpp_centrality - parallel function
#'
#' sample is used to estimate timing, by calculating centrality from just a few
#' vertices.
#' @noRd
rcpp_centrality <- function (graph, vert_map_in, heap_type, dist_threshold, edge_centrality, sample) {
    .Call (`_dodgr_rcpp_centrality`, graph, vert_map_in, heap_type, dist_threshold, edge_centrality, sample)
}

#' rcpp_concaveman
#' @noRd
rcpp_concaveman <- function (xy, hull_in, concavity, length_threshold) {
    .Call (`_dodgr_rcpp_concaveman`, xy, hull_in, concavity, length_threshold)
}

#' De-duplicate edges by replacing with minimal weighted distances and times
#'
#' @param graph Full graph in any form
#' @param fr_col Name of column holding from edge labels
#' @param to_col Name of column holding to edge labels
#' @param d_col Name of column holding weighted distances
#' @param t_col Name of column holding weighted times (or "" if no weighted
#' times).
#' @return A `data.frame` of 3 columns: 'from', 'to', and 'd', where 'd' is the
#' minimal value taken from all duplicated edges. If 't_col' is specified, the
#' equivalent minimal times are in the lower half of the result.
#' @noRd
rcpp_deduplicate <- function (graph, fr_col, to_col, d_col, t_col) {
    .Call (`_dodgr_rcpp_deduplicate`, graph, fr_col, to_col, d_col, t_col)
}

#' Make unordered_set of all new edge names
#' @noRd
NULL

#' Make vector of all new edge names
#' @noRd
NULL

#' Get numbers of old edges corresponding to each contracted edge
#' @noRd
NULL

#' Collect sets of all from and to vertices for each set of edges corresponding
#' to each contracted edge. These sets aren't in any particular order, but the
#' two sets may be used to match the from and to vertices. These sets are then
#' arranged into sequences in the subsequent function,
#' \code{order_vert_sequences}.
#' @noRd
NULL

#' rcpp_aggregate_to_sf
#'
#' Aggregate a dodgr network data.frame to an sf LINESTRING data.frame
#'
#' @param graph_full Rcpp::DataFrame containing the **full** graph
#' @param graph_contr Rcpp::DataFrame containing the **contracted** graph
#' @param edge_map Rcpp::DataFrame containing the edge map returned from
#' \code{dodgr_contract_graph}
#'
#' @return Rcpp::List object of `sf::LINESTRING` geoms
#'
#' @noRd
rcpp_aggregate_to_sf <- function (graph_full, graph_contr, edge_map) {
    .Call (`_dodgr_rcpp_aggregate_to_sf`, graph_full, graph_contr, edge_map)
}

#' rcpp_flows_aggregate_par
#'
#' @param graph The data.frame holding the graph edges
#' @param vert_map_in map from <std::string> vertex ID to (0-indexed) integer
#' index of vertices
#' @param fromi Index into vert_map_in of vertex numbers
#' @param toi Index into vert_map_in of vertex numbers
#' @param tol Relative tolerance in terms of flows below which targets
#' (to-vertices) are not considered.
#'
#' @note The parallelisation is achieved by dumping the results of each thread
#' to a file, with aggregation performed at the end by simply reading back and
#' aggregating all files. There is no way to aggregate into a single vector
#' because threads have to be independent. The only danger with this approach
#' is that multiple threads may generate the same file names, but with names 10
#' characters long, that chance should be 1 / 62 ^ 10.
#'
#' @noRd
rcpp_flows_aggregate_par <- function (graph, vert_map_in, fromi, toi_in, flows, norm_sums, tol, heap_type) {
    .Call (`_dodgr_rcpp_flows_aggregate_par`, graph, vert_map_in, fromi, toi_in, flows, norm_sums, tol, heap_type)
}

#' rcpp_flows_disperse_par
#'
#' Modified version of \code{rcpp_flows_aggregate} that aggregates flows to all
#' destinations from given set of origins, with flows attenuated by distance
#' from those origins.
#'
#' @param graph The data.frame holding the graph edges
#' @param vert_map_in map from <std::string> vertex ID to (0-indexed) integer
#' index of vertices
#' @param fromi Index into vert_map_in of vertex numbers
#' @param k Coefficient of (current proof-of-principle-only) exponential
#' distance decay function.  If value of \code{k<0} is given, a standard
#' logistic polynomial will be used.
#'
#' @note The flow data to be used for aggregation is a matrix mapping flows
#' between each pair of from and to points.
#'
#' @noRd
rcpp_flows_disperse_par <- function (graph, vert_map_in, fromi, k, dens, tol, heap_type) {
    .Call (`_dodgr_rcpp_flows_disperse_par`, graph, vert_map_in, fromi, k, dens, tol, heap_type)
}

#' rcpp_flows_si
#'
#' @param graph The data.frame holding the graph edges
#' @param vert_map_in map from <std::string> vertex ID to (0-indexed) integer
#' index of vertices
#' @param fromi Index into vert_map_in of vertex numbers
#' @param toi Index into vert_map_in of vertex numbers
#' @param kvec Vector of k-values for each fromi
#' @param nvec Vector of density-values for each fromi
#' @param tol Relative tolerance in terms of flows below which targets
#' (to-vertices) are not considered.
#'
#' @noRd
rcpp_flows_si <- function (graph, vert_map_in, fromi, toi_in, kvec, dens_from, dens_to, norm_sums, tol, heap_type) {
    .Call (`_dodgr_rcpp_flows_si`, graph, vert_map_in, fromi, toi_in, kvec, dens_from, dens_to, norm_sums, tol, heap_type)
}

#' @noRd
rcpp_fundamental_cycles <- function (graph, verts) {
    .Call (`_dodgr_rcpp_fundamental_cycles`, graph, verts)
}

#' get_to_from
#'
#' Get one pair of two and from edges and vertices. Main task is to make sure
#' that bi-directed edges ("intermediate_double") correctly return the
#' **different** values of from and to vertices and edges.
#'
#' @noRd
NULL

#' same_hwy_type
#'
#' Determine whether two edges represent the same weight category (type of
#' highway for street networks, for example). Categories are not retained in
#' converted graphs, but can be discerned by comparing ratios of weighted to
#' non-weighted distances.
#' @noRd
NULL

#' rcpp_contract_graph
#'
#' Removes nodes and edges from a graph that are not needed for routing
#'
#' @param graph graph to be processed
#'
#' @return \code{Rcpp::List} containing one \code{data.frame} with the
#' contracted graph, one \code{data.frame} with the original graph and one
#' \code{data.frame} containing information about the relating edge ids of the
#' original and contracted graph.
#'
#' @noRd
rcpp_contract_graph <- function (graph, vertlist_in) {
    .Call (`_dodgr_rcpp_contract_graph`, graph, vertlist_in)
}

#' rcpp_merge_cols
#'
#' Merge columns in directed graph to form aggregate undirected columns, and
#' return a corresponding undirected graph useful for visualisation.
#'
#' @param graph The result of a call to \code{dodgr_flows_aggregate/disperse}
#' or similar function resuling in columns of directed values.
#' @return A single vector of aggregate values with non-zero values only for
#' those edges to be retained in the directed graph.
#'
#' @noRd
rcpp_merge_cols <- function (graph) {
    .Call (`_dodgr_rcpp_merge_cols`, graph)
}

#' sample_one_edge_no_comps
#'
#' Sample one edge for graph that has no pre-calculated components. Only used
#' in \code{sample_one_vertex}
#'
#' @param edge_map edge_map
#' @return std::vector of 2 elements: [0] with value of largest connected
#' component; [1] with random index to one edge that is part of that component.
#' @noRd
NULL

#' sample_one_edge_with_comps
#'
#' Sample one edge for graph that has pre-calculated components. Only used in
#' \code{sample_one_vertex}
#'
#' @param edge_map edge_map
#' @return Random index to one edge that is part of the largest connected
#' component.
#' @noRd
NULL

#' rcpp_sample_graph
#'
#' Randomly sample one connected componnent of a graph
#'
#' @param graph graph to be processed
#' @param nverts_to_sample Number of vertices to sample
#' @param quiet If TRUE, display progress
#'
#' @return Smaller sub-set of \code{graph}
#'
#' @noRd
rcpp_sample_graph <- function (graph, nverts_to_sample) {
    .Call (`_dodgr_rcpp_sample_graph`, graph, nverts_to_sample)
}

#' graph_has_components
#'
#' Does a graph have a vector of connected component IDs? Only used in
#' \code{sample_one_vertex}
#' @noRd
NULL

#' @name graph_from_df
#'
#' Convert a standard graph data.frame into an object of class graph. Graphs
#' are standardised with the function \code{dodgr_convert_graph()$graph}, and
#' contain only the four columns [from, to, d, w]
#'
#' @noRd
NULL

#' identify_graph_components
#'
#' Identify initial graph components for each **vertex**
#' Identification for edges is subsequently perrformed with
#' \code{rcpp_get_component_vector}.
#'
#' @param v unordered_map <vertex_id_t, vertex_t>
#' @param com component map from each vertex to component numbers
#' @noRd
NULL

#' rcpp_get_component_vector
#'
#' Get component numbers for each edge of graph
#'
#' @param graph graph to be processed; stripped down and standardised to five
#' columns
#'
#' @return Two vectors: one of edge IDs and one of corresponding component
#' numbers
#' @noRd
rcpp_get_component_vector <- function (graph) {
    .Call (`_dodgr_rcpp_get_component_vector`, graph)
}

#' rcpp_unique_rownames
#'
#' Construct vertex (from, to) ID values from unique pairs of coordinates
#' rounded to <precision>. Used when vertices have no ID values.
#'
#' @noRd
rcpp_unique_rownames <- function (xyfrom, xyto, precision = 10L) {
    .Call (`_dodgr_rcpp_unique_rownames`, xyfrom, xyto, precision)
}

#' Determine which side of intersecting line a point lies on.
#'
#' @param (ax, ay) Coordinates of one end of line
#' @param (bx, by) Coordinates of other end of line
#' @param (x, y) Coordinates of point
#' @return 0 if point on line, -1 if to the left; +1 if to the right.
#'
#' @noRd
NULL

#' Simple match of points to nearest vertices
#' @noRd
NULL

#' Match points to nearest edge of graph at which perpendicular from point
#' bisects edges. Uses psuedo-code from
#' https://stackoverflow.com/a/6853926
#' @noRd
NULL

#' rcpp_points_index_par
#'
#' Get index of nearest vertices to list of points
#'
#' @param xy Rcpp::DataFrame containing the vertex coordinates of the graph
#' @param pts Rcpp::DataFrame containing the points to be matched
#'
#' @return 0-indexed Rcpp::NumericVector index into graph of nearest points
#'
#' @noRd
rcpp_points_index_par <- function (xy, pts) {
    .Call (`_dodgr_rcpp_points_index_par`, xy, pts)
}

#' rcpp_points_to_edges_par
#'
#' Get index of nearest edges to list of points
#'
#' @param graph Rcpp::DataFrame containing the full edge-based graph
#' @param pts Rcpp::DataFrame containing the points to be matched
#'
#' @return 0-indexed Rcpp::NumericVector index into graph of nearest points
#'
#' @noRd
rcpp_points_to_edges_par <- function (graph, pts) {
    .Call (`_dodgr_rcpp_points_to_edges_par`, graph, pts)
}

#' rcpp_get_sp_dists_par
#'
#' @noRd
rcpp_get_sp_dists_par <- function (graph, vert_map_in, fromi, toi_in, heap_type, is_spatial) {
    .Call (`_dodgr_rcpp_get_sp_dists_par`, graph, vert_map_in, fromi, toi_in, heap_type, is_spatial)
}

#' rcpp_get_sp_dists_nearest
#'
#' @noRd
rcpp_get_sp_dists_nearest <- function (graph, vert_map_in, fromi, toi_in, heap_type) {
    .Call (`_dodgr_rcpp_get_sp_dists_nearest`, graph, vert_map_in, fromi, toi_in, heap_type)
}

#' rcpp_get_sp_dists_paired_par
#'
#' @noRd
rcpp_get_sp_dists_paired_par <- function (graph, vert_map_in, fromi, toi, heap_type, is_spatial) {
    .Call (`_dodgr_rcpp_get_sp_dists_paired_par`, graph, vert_map_in, fromi, toi, heap_type, is_spatial)
}

#' rcpp_get_iso
#'
#' @noRd
rcpp_get_iso <- function (graph, vert_map_in, fromi, dlim, heap_type) {
    .Call (`_dodgr_rcpp_get_iso`, graph, vert_map_in, fromi, dlim, heap_type)
}

#' rcpp_get_sp_dists
#'
#' @noRd
rcpp_get_sp_dists <- function (graph, vert_map_in, fromi, toi_in, heap_type) {
    .Call (`_dodgr_rcpp_get_sp_dists`, graph, vert_map_in, fromi, toi_in, heap_type)
}

#' rcpp_get_paths
#'
#' @param graph The data.frame holding the graph edges
#' @param vert_map_in map from <std::string> vertex ID to (0-indexed) integer
#' index of vertices
#' @param fromi Index into vert_map_in of vertex numbers
#' @param toi Index into vert_map_in of vertex numbers
#'
#' @note The graph is constructed with 0-indexed vertex numbers contained in
#' code{vert_map_in}. Both \code{fromi} and \code{toi} already map directly
#' onto these. The graph has to be constructed by first constructing a
#' \code{std::map} object (\code{vertmap}) for \code{vert_map_in}, then
#' translating all \code{graph["from"/"to"]} values into these indices. This
#' construction is done in \code{inst_graph}.
#'
#' @note Returns 1-indexed values indexing directly into the R input
#'
#' @noRd
rcpp_get_paths <- function (graph, vert_map_in, fromi, toi_in, heap_type) {
    .Call (`_dodgr_rcpp_get_paths`, graph, vert_map_in, fromi, toi_in, heap_type)
}

rcpp_get_paths_pairwise <- function (graph, vert_map_in, fromi, toi_in, heap_type) {
    .Call (`_dodgr_rcpp_get_paths_pairwise`, graph, vert_map_in, fromi, toi_in, heap_type)
}

#' rcpp_get_sp_dists_categorical
#'
#' The `graph` must have an `edge_type` column of non-negative integers,
#' with 0 denoting edges which are not aggregated, and all other values
#' defining aggregation categories.
#'
#' Implemented in parallal form only; no single-threaded version, and
#' only for AStar (so graphs must be spatial).
#' @noRd
rcpp_get_sp_dists_categorical <- function (graph, vert_map_in, fromi, toi_in, heap_type, proportions_only) {
    .Call (`_dodgr_rcpp_get_sp_dists_categorical`, graph, vert_map_in, fromi, toi_in, heap_type, proportions_only)
}

#' rcpp_get_sp_dists_categ_paired
#'
#' Pairwise version of 'get_sp_dists_categorical'. The `graph` must have an
#' `edge_type` column of non-negative integers, with 0 denoting edges which are
#' not aggregated, and all other values defining aggregation categories.
#'
#' Implemented in parallal form only; no single-threaded version, and
#' only for AStar (so graphs must be spatial).
#' @noRd
rcpp_get_sp_dists_categ_paired <- function (graph, vert_map_in, fromi, toi_in, heap_type) {
    .Call (`_dodgr_rcpp_get_sp_dists_categ_paired`, graph, vert_map_in, fromi, toi_in, heap_type)
}

#' rcpp_get_sp_dists_cat_threshold
#'
#' The `graph` must have an `edge_type` column of non-negative integers,
#' with 0 denoting edges which are not aggregated, and all other values
#' defining aggregation categories.
#'
#' Implemented in parallal form only; no single-threaded version, and
#' only for AStar (so graphs must be spatial).
#' @noRd
rcpp_get_sp_dists_cat_threshold <- function (graph, vert_map_in, fromi, dlimit, heap_type) {
    .Call (`_dodgr_rcpp_get_sp_dists_cat_threshold`, graph, vert_map_in, fromi, dlimit, heap_type)
}

#' rcpp_gen_hash
#'
#' Efficient generation of long sequences of hash keys
#'
#' @noRd
rcpp_gen_hash <- function (n, hash_len) {
    .Call (`_dodgr_rcpp_gen_hash`, n, hash_len)
}

#' rcpp_sf_as_network
#'
#' Return OSM data from Simple Features format input
#'
#' @param sf_lines An sf collection of LINESTRING objects
#' @param pr Rcpp::DataFrame containing the weighting profile
#'
#' @return Rcpp::List objects of OSM data, one matrix of numeric and one of
#' character values. The former contain 7 columns:
#' 1. sf geom index
#' 2. from longitude
#' 3. from latitude
#' 4. to longitude
#' 5. to latitude
#' 6. distance
#' 7. weighted_distance
#' The character value matrix  has 4 columns of:
#' 1. from ID
#' 2. to ID
#' 3. highway type
#' 4. OSM way ID
#'
#' @noRd
rcpp_sf_as_network <- function (sf_lines, pr) {
    .Call (`_dodgr_rcpp_sf_as_network`, sf_lines, pr)
}

#' rcpp_route_times
#'
#' @noRd
rcpp_route_times <- function (graph, left_side, turn_penalty) {
    .Call (`_dodgr_rcpp_route_times`, graph, left_side, turn_penalty)
}
