% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_load_streetnet.R
\name{dodgr_load_streetnet}
\alias{dodgr_load_streetnet}
\title{Load a street network previously saved with \link{dodgr_save_streetnet}.}
\usage{
dodgr_load_streetnet(filename)
}
\arguments{
\item{filename}{Name (with optional full path) of file to be loaded.}
}
\description{
This always returns the full, non-contracted graph. The contracted graph can
be generated by passing the result to \link{dodgr_contract_graph}.
}
\examples{
net <- weight_streetnet (hampi)
f <- file.path (tempdir (), "streetnet.Rds")
dodgr_save_streetnet (net, f)
clear_dodgr_cache () # rm cached objects from tempdir
# at some later time, or in a new R session:
net <- dodgr_load_streetnet (f)
}
\seealso{
Other cache: 
\code{\link{clear_dodgr_cache}()},
\code{\link{dodgr_cache_off}()},
\code{\link{dodgr_cache_on}()},
\code{\link{dodgr_save_streetnet}()}
}
\concept{cache}
