% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_pptx_to_pdf.R
\name{convert_to_pdf}
\alias{convert_to_pdf}
\title{Convert a Document (usually PowerPoint) to a PDF}
\usage{
convert_to_pdf(path, pdf_file = sub("[.]pptx", ".pdf", path))
}
\arguments{
\item{path}{path to the document, can be PowerPoint or DOCX}

\item{pdf_file}{output PDF file name.  By default, creates a PDF in the
same directory as the \code{path} file.
This functionality requires the use of
LibreOffice and the \code{soffice} binary it contains.  See
\link{set_libreoffice_path} for more information.  Note,}
}
\description{
Convert a Document (usually PowerPoint) to a PDF
}
\examples{
\dontrun{
path = system.file("examples/ex.pptx", package="docxtractr")
pdf <- convert_to_pdf(path, pdf_file = tempfile(fileext = ".pdf"))
path = system.file("examples/data.docx", package="docxtractr")
pdf_doc <- convert_to_pdf(path, pdf_file = tempfile(fileext = ".pdf"))
}
}
