% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nint.R
\name{nint_integrateNCube}
\alias{nint_integrateNCube}
\alias{nint_integrateNCube_integrate}
\alias{nint_integrateNCube_cubature}
\alias{nint_integrateNCube_SparseGrid}
\title{Integrate Hypercube}
\usage{
nint_integrateNCube(f, lowerLimit, upperLimit, ...)

nint_integrateNCube_integrate(integrate)

nint_integrateNCube_cubature(adaptIntegrate)

nint_integrateNCube_SparseGrid(createIntegrationGrid)
}
\arguments{
\item{integrate}{\code{function(f, lowerLimit, upperLimit, ...)} which calls \code{integrate}.}

\item{adaptIntegrate}{\code{function(f, lowerLimit, upperLimit, ...)} which calls \code{cubature::adaptIntegrate}.}

\item{createIntegrationGrid}{\code{function(dimension)} which calls \code{SparseGrid::createIntegrationGrid}.}

\item{f}{the scalar-valued wrapper function to be integrated.}

\item{lowerLimit}{the lower limits of integration.}

\item{upperLimit}{the upper limits of integration.}

\item{...}{other arguments passed to \code{f}.}
}
\value{
\code{nint_integrateNCube} returns a single numeric.

\code{nint_integrateNCube_integrate} returns a recursive implementation for \code{nint_integrateNCube} based on one dimensional integration.

\code{nint_integrateNCube_cubature} returns a trivial implementation for \code{nint_integrateNCube} indirectly based on \code{cubature::adaptIntegrate}.

\code{nint_integrateNCube_SparseGrid} returns an implementation for \code{nint_integrateNCube} indirectly based on \code{SparseGrid::createIntegrationGrid}.
}
\description{
Interface to the integration over interval dimensions.
}
\details{
\code{nint_integrate} uses \code{nint_integrateNCube} to handle interval dimensions.
See examples below on how to deploy different solutions.

The function built by \code{nint_integrateNCube_integrate} calls \code{integrate} (argument) recursively.
The number of function evaluations therefore increases exponentially with the number of dimensions (\code{(subdivisions * 21) ** D} if \code{integrate}, the default, is used).
At the moment it is the default method because no additional package is required.
However, you most likely want to consider different solutions.

The function built by \code{nint_integrateNCube_cubature} is a trivial wrapper for \code{cubature::adaptIntegrate}.

The function built by \code{nint_integrateNCube_SparseGrid} is an almost trivial wrapper for \code{SparseGrid::createIntegrationGrid}.
It scales the grid to the integration region.
}
\examples{
## integrate with defaults (stats::integrate)
nint_integrate(sin, nint_space(nint_intvDim(pi/4, 3*pi/4)))


dfltNCube = nint_integrateNCube

## prepare for integrateA
ncube = function(f, lowerLimit, upperLimit, ...) {
    cat('using integrateA\\n')
    integrateA(f, lowerLimit, upperLimit, ..., subdivisions=2)
}
ncube = nint_integrateNCube_integrate(ncube)
unlockBinding('nint_integrateNCube', environment(nint_integrate))
assign('nint_integrateNCube', ncube, envir=environment(nint_integrate))

## integrate with integrateA
nint_integrate(sin, nint_space(nint_intvDim(pi/4, 3*pi/4)))


## prepare for cubature
ncube = function(f, lowerLimit, upperLimit, ...) {
    cat('using cubature\\n')
    r = cubature::adaptIntegrate(f, lowerLimit, upperLimit, ..., maxEval=1e3)
    return(r$integral)
}
unlockBinding('nint_integrateNCube', environment(nint_integrate))
assign('nint_integrateNCube', ncube, envir=environment(nint_integrate))

## integrate with cubature
nint_integrate(sin, nint_space(nint_intvDim(pi/4, 3*pi/4)))


## prepare for SparseGrid
ncube = function(dimension) {
    cat('using SparseGrid\\n')
    SparseGrid::createIntegrationGrid('GQU', dimension, 7)
}
ncube = nint_integrateNCube_SparseGrid(ncube)
unlockBinding('nint_integrateNCube', environment(nint_integrate))
assign('nint_integrateNCube', ncube, envir=environment(nint_integrate))

## integrate with SparseGrid
nint_integrate(sin, nint_space(nint_intvDim(pi/4, 3*pi/4)))


assign('nint_integrateNCube', dfltNCube, envir=environment(nint_integrate))
}
\seealso{
\code{\link{nint_integrate}}

\code{\link{integrateA}}, \code{\link[stats]{integrate}}

\code{\link[cubature]{adaptIntegrate}} in package \pkg{cubature}

\code{\link[SparseGrid]{createIntegrationGrid}} in package \pkg{SparseGrid}
}
