% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/main.R
\name{Defficiency}
\alias{Defficiency}
\title{D Efficiency}
\usage{
Defficiency(des, ref, mod, dsNames = NULL, names = NULL)
}
\arguments{
\item{des}{some design.}

\item{ref}{some design, the reference.}

\item{mod}{some model.}

\item{dsNames}{a vector of names or indices, the subset of parameters to use. Defaults to the set of parameters in use.}

\item{names}{a vector of names or indices, the set of parameters to use. Defaults to the parameters for which the Fisher information is available.}
}
\value{
\code{Defficiency} returns a single numeric.
}
\description{
\code{Defficiency} computes the D- or Ds-efficiency measure for some design with respect to some reference design.
}
\details{
D efficiency is defined as
\deqn{\left(\frac{\left|M(\xi,\bar{\theta})\right|}{\left|M(\xi^{*},\bar{\theta})\right|}\right)^{1/n}}{( det(M(\xi, \theta))  /  det(M(\xi*, \theta)) )**(1/n)}
and Ds efficiency as
\deqn{\left(\frac{\left|M_{11}(\xi,\bar{\theta})-M_{12}(\xi,\bar{\theta})M_{22}^{-1}(\xi,\bar{\theta})M_{12}^{T}(\xi,\bar{\theta})\right|}{\left|M_{11}(\xi^{*},\bar{\theta})-M_{12}(\xi^{*},\bar{\theta})M_{22}^{-1}(\xi^{*},\bar{\theta})M_{12}^{T}(\xi^{*},\bar{\theta})\right|}\right)^{1/s}}{( det(M11(\xi, \theta) - M12(\xi, \theta) \%*\% solve(M22(\xi, \theta)) \%*\% t(M12(\xi, \theta)))  /  det(M11(\xi*, \theta) - M12(\xi*, \theta) \%*\% solve(M22(\xi*, \theta)) \%*\% t(M12(\xi*, \theta))) )**(1/s)}

where \eqn{M_{11}}{M11} is the submatrix corresponding to the parameters in \code{dsNames}, \eqn{M_{22}}{M22} is the submatrix corresponding to the parameters in \code{names} which are not in \code{dsNames}, and \eqn{M_{12}}{M12} is defined as the resulting off diagonal submatrix.
}
\examples{
## see examples for param
}
\seealso{
\code{\link{design}}, \code{\link{param}}
}

