% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initiate_centers.R
\name{initiate_centers}
\alias{initiate_centers}
\title{Initiate centers for clustering algorithm}
\usage{
initiate_centers(data, N = 1000, t = 1, k, algorithms = NULL, seeds.N = NULL)
}
\arguments{
\item{data}{Dataset that clustering will be applied on}

\item{N}{Integer. Number clustering initialization (set of centers) to
generate}

\item{t}{Numeric between 0 and 1. weight coefficient between only random
centers (t=1) and only centers from clustering (t=0).}

\item{k}{Vector of size N containing the number of centers for each
initialization.}

\item{algorithms}{list of algorithm(s) (size \code{N * (1-t)} to generate
centers if t!=1, given as characters. Possible values are "\code{km}" for
'K-means', "\code{kmed}" for 'K-medians',
\code{"hclust.mean", "hclust.med"} for hierarchical clustering with mean
or median position of the center.}

\item{seeds.N}{(optional) vector of size N containing seeds for each
initialization.}
}
\value{
list of size \code{N} containing coordinates of centers for
clustering initialization.
}
\description{
Initiate centers for clustering algorithm
}
\examples{
Cent.init <- initiate_centers(data = iris[, 1:4], N = 10,
                              k = sample(c(2:7), 10, replace = TRUE))
}
