% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome.R
\name{entrez_to_symbol}
\alias{entrez_to_symbol}
\title{Obtain gene symbols for entrezgene IDs}
\usage{
entrez_to_symbol(x, species, dir_save = tempdir(), verbose = TRUE)
}
\arguments{
\item{x}{A vector of entrezgene IDs.}

\item{species}{The species used to obtain the entrezgene IDs. For example:
"Homo sapiens", "m musculus", "C. elegans", or "S cerevisiae".
"Human" and "mouse" can also be used and will be converted to the
correct species name.}

\item{dir_save}{The directory to store annotation reference. Future
calls to this function will use the stored annotations. This speeds up the
operation and allows for reproducibility in the event that the \code{biomaRt}
database is updated. Set to NULL to disable. By default, it uses a
temporary directory to store files during the R session.}

\item{verbose}{Set to FALSE to avoid messages.}
}
\value{
A data frame with two columns: the first contains the original
entrezgene IDs, and the second contains the corresponding gene symbols.
MGI symbols are returned when \code{species = "Mus musculus"} and HGNC symbols
are returned otherwise.
}
\description{
Uses \code{biomaRt} \insertCite{biomart}{dnapath} to map entrezgene IDs to gene
symbols for a given species. Obtains MGI symbols for mouse species and
HGNC symbols for other species
(note, note that this mapping may not work for all species).
The output of this function can be used in \code{\link{rename_genes}}.
}
\details{
If entrezgene IDs are used in a \code{dnapath_list} or \code{dnapath}
object, or a pathway list, then \code{\link{get_genes}} can be used to
extract them and used for the \code{x} argument here.
}
\note{
Internet connection is required to connect to biomaRt.
}
\examples{
\donttest{
data(meso)
# The meso gene expression data contains entrezgene IDs. 
# These can be converted to gene symbols.
gene_mat <- entrez_to_symbol(colnames(meso$gene_expression), species = "human")
}
}
\references{
\insertRef{biomart}{dnapath}
}
\seealso{
\code{\link{symbol_to_entrez}}, \code{\link{get_genes}}
}
