% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmbc_ic.R
\name{dmbc_IC}
\alias{dmbc_IC}
\title{Model selection of DMBC models.}
\usage{
dmbc_IC(
  data,
  pmax = 3,
  Gmax = 5,
  control = dmbc_control(),
  prior = NULL,
  est = "mean"
)
}
\arguments{
\item{data}{An object of class \code{dmbc_data} containing the data
to analyze.}

\item{pmax}{A length-one numeric vector indicating the maximum number of
dimensions of the latent space to consider.}

\item{Gmax}{A length-one numeric vector indicating the maximum number of
cluster to consider.}

\item{control}{A list of control parameters that affect the sampling
but do not affect the posterior distribution See
\code{\link{dmbc_control}()} for more details.}

\item{prior}{A list containing the prior hyperparameters. See
\code{\link{dmbc_prior}()} for more details.}

\item{est}{A length-one character vector indicating the estimate type to
use. Possible values are \code{mean}, \code{median}, \code{ml} and
\code{map}.}
}
\value{
A \code{dmbc_ic} object.
}
\description{
\code{dmbc_IC()} is the main function for simultaneously selecting the
  optimal latent space dimension (\emph{p}) and number of clusters
  (\emph{G}) for a DMBC analysis.
}
\examples{
\donttest{
data(simdiss, package = "dmbc")

pmax <- 2
Gmax <- 2
prm.prop <- list(z = 1.5, alpha = .75)
burnin <- 2000
nsim <- 1000
seed <- 1809

set.seed(seed)

control <- list(burnin = burnin, nsim = nsim, z.prop = prm.prop[["z"]],
  alpha.prop = prm.prop[["alpha"]], random.start = TRUE, verbose = TRUE,
  thin = 10, store.burnin = TRUE)
sim.ic <- dmbc_IC(data = simdiss, pmax = pmax, Gmax = Gmax, control = control,
  est = "mean")

pmax <- pmax + 1
Gmax <- Gmax + 2
new.ic <- update(sim.ic, pmax = pmax, Gmax = Gmax)
new.ic

# plot the results
library(bayesplot)
library(ggplot2)
color_scheme_set("mix-yellow-blue")
p <- plot(new.ic, size = c(4, 1.5))
p + panel_bg(fill = "gray90", color = NA)
}
}
\references{
Venturini, S., Piccarreta, R. (2019), "A Bayesian Approach for Model-Based
  Clustering of Several Binary Dissimilarity Matrices: the \pkg{dmbc}
  Package in \code{R}", Technical report.
}
\seealso{
\code{\link{dmbc}()} for fitting a DMBC model.

\code{\link{dmbc_ic}} for a description of the elements included
  in the returned object.
}
\author{
Sergio Venturini \email{sergio.venturini@unito.it}
}
