% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasEquiv_EffectSize_Wrappers.R
\name{lavaan_dmacs}
\alias{lavaan_dmacs}
\title{Summary of measurement nonequivalence effects}
\usage{
lavaan_dmacs(fit, RefGroup = 1, dtype = "pooled", ...)
}
\arguments{
\item{fit}{is a fitted lavaan multi-group object. Only CFA models are
supported, and be sure to have an anchor item.}

\item{RefGroup}{can be the name of the reference group (as a string),
or the index of the reference group (as a number). RefGroup defaults to
the first group if no value is provided. It is strongly recommended to
provide the reference group as a string, since group names in data are
often ordered by their appearance in the data, not alphabetically.}

\item{dtype}{described the pooling of standard deviations for use in the
denominator of the dmacs effect size. Possibilities are "pooled" for
pooled standard deviations, or "glass" for always using the standard
deviation of the reference group.}

\item{...}{other parameters to be used in functions that
\code{lavaan_dmacs} calls, most likely \code{stepsize} for the
\code{\link{item_dmacs}} and \code{\link{delta_mean_item}} functions.}
}
\value{
A list, indexed by group, of lists of measurement nonequivalence
effects from Nye and Drasgow (2011), including dmacs, expected bias in
the mean score by item,
expected bias in the mean total score, and expected bias in the variance
of the total score. Expected bias in the variance of the total score is
only supplied for unidimensional models in the current version of this
package
}
\description{
\code{lavaan_dmacs} returns a summary of measurement non-equivalence
effects given a fitted multigroup lavaan object.
}
\section{References}{

Nye, C. & Drasgow, F. (2011). Effect size indices for analyses of
measurement equivalence: Understanding the practical importance of
differences between groups. \emph{Journal of Applied Psychology, 96}(5),
966-980.
}

\examples{
HS.model <- '  visual  =~ x1 + x2 + x3
               textual =~ x4 + x5 + x6
               speed   =~ x7 + x8 + x9 '
fit <- lavaan::cfa(HS.model,
                  data = lavaan::HolzingerSwineford1939,
                  group = "school")
lavaan_dmacs(fit, RefGroup = "Pasteur")


}
