% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_dbi.R
\name{plot_correlate.tbl_dbi}
\alias{plot_correlate.tbl_dbi}
\title{Visualize correlation plot of numerical data}
\usage{
\method{plot_correlate}{tbl_dbi}(
  .data,
  ...,
  in_database = FALSE,
  collect_size = Inf,
  method = c("pearson", "kendall", "spearman"),
  typographic = TRUE,
  base_family = NULL
)
}
\arguments{
\item{.data}{a tbl_dbi.}

\item{...}{one or more unquoted expressions separated by commas.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
If the first expression is negative, plot_correlate() will automatically start with all variables.
These arguments are automatically quoted and evaluated in a context where column names
represent column positions.
They support unquoting and splicing.}

\item{in_database}{Specifies whether to perform in-database operations. 
If TRUE, most operations are performed in the DBMS. if FALSE, 
table data is taken in R and operated in-memory. Not yet supported in_database = TRUE.}

\item{collect_size}{a integer. The number of data samples from the DBMS to R. 
Applies only if in_database = FALSE.}

\item{method}{a character string indicating which correlation coefficient (or covariance) is 
to be computed. One of "pearson" (default), "kendall", or "spearman": can be abbreviated.

See vignette("EDA") for an introduction to these concepts.}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}

\item{base_family}{character. The name of the base font family to use 
for the visualization. If not specified, the font defined in dlookr is applied. (See details)}
}
\description{
The plot_correlate() visualize correlation plot
for find relationship between two numerical(INTEGER, NUMBER, etc.) column of 
the DBMS table through tbl_dbi.
}
\details{
The scope of the visualization is the provide a correlation information.
Since the plot is drawn for each variable, if you specify more than
one variable in the ... argument, the specified number of plots are drawn.

The direction of the diagonal is top-left to bottom-right. and color of the 
cells is 'red' to -1, 'blue' to 1.

The base_family is selected from "Roboto Condensed", "Liberation Sans Narrow",
"NanumSquare", "Noto Sans Korean". If you want to use a different font, 
use it after loading the Google font with import_google_font().
}
\seealso{
\code{\link{plot.correlate}}, \code{\link{plot_outlier.tbl_dbi}}.
}
\keyword{internal}
