% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_dbi.R
\name{plot_correlate.tbl_dbi}
\alias{plot_correlate.tbl_dbi}
\title{Visualize correlation plot of numerical data}
\usage{
\method{plot_correlate}{tbl_dbi}(
  .data,
  ...,
  in_database = FALSE,
  collect_size = Inf,
  method = c("pearson", "kendall", "spearman")
)
}
\arguments{
\item{.data}{a tbl_dbi.}

\item{...}{one or more unquoted expressions separated by commas.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
If the first expression is negative, plot_correlate() will automatically start with all variables.
These arguments are automatically quoted and evaluated in a context where column names
represent column positions.
They support unquoting and splicing.}

\item{in_database}{Specifies whether to perform in-database operations. 
If TRUE, most operations are performed in the DBMS. if FALSE, 
table data is taken in R and operated in-memory. Not yet supported in_database = TRUE.}

\item{collect_size}{a integer. The number of data samples from the DBMS to R. 
Applies only if in_database = FALSE.}

\item{method}{a character string indicating which correlation coefficient (or covariance) is 
to be computed. One of "pearson" (default), "kendall", or "spearman": can be abbreviated.

See vignette("EDA") for an introduction to these concepts.}
}
\description{
The plot_correlate() visualize correlation plot
for find relationship between two numerical(INTEGER, NUMBER, etc.) column of 
the DBMS table through tbl_dbi.
}
\details{
The scope of the visualization is the provide a correlation information.
Since the plot is drawn for each variable, if you specify more than
one variable in the ... argument, the specified number of plots are drawn.
}
\examples{
library(dplyr)

# connect DBMS
con_sqlite <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")

# copy heartfailure to the DBMS with a table named TB_HEARTFAILURE
copy_to(con_sqlite, heartfailure, name = "TB_HEARTFAILURE", overwrite = TRUE)

# Using pipes ---------------------------------
# Visualize correlation plot of all numerical variables
con_sqlite \%>\% 
  tbl("TB_HEARTFAILURE") \%>\% 
  plot_correlate()
  
# Positive values select variables, and In-memory mode and collect size is 200
con_sqlite \%>\% 
  tbl("TB_HEARTFAILURE") \%>\% 
  plot_correlate(platelets, sodium, collect_size = 200)
  
# Negative values to drop variables
con_sqlite \%>\% 
  tbl("TB_HEARTFAILURE") \%>\% 
  plot_correlate(-platelets, -sodium)
  
# Positions values select variables
con_sqlite \%>\% 
  tbl("TB_HEARTFAILURE") \%>\% 
  plot_correlate(1)
  
# Positions values select variables
con_sqlite \%>\% 
  tbl("TB_HEARTFAILURE") \%>\% 
  plot_correlate(-1, -2, -3, -5, -6)

# Using pipes & dplyr -------------------------
# Visualize correlation plot of 'sodiumsodium' variable by 'smoking'
# and 'death_event' variables.
con_sqlite \%>\% 
  tbl("TB_HEARTFAILURE") \%>\% 
  group_by(smoking, death_event) \%>\%
  plot_correlate(sodium)

# Extract only those with 'smoking' variable level is "Yes",
# and visualize correlation plot of 'sodium' variable by 'sex'
# and 'death_event' variables.
con_sqlite \%>\% 
  tbl("TB_HEARTFAILURE") \%>\% 
  filter(smoking == "Yes") \%>\%
  group_by(sex, death_event) \%>\%
  plot_correlate(sodium)

# Disconnect DBMS   
DBI::dbDisconnect(con_sqlite)

}
\seealso{
\code{\link{plot_correlate.data.frame}}, \code{\link{plot_outlier.tbl_dbi}}.
}
