% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning.R
\name{summary.optimal_bins}
\alias{summary.optimal_bins}
\title{Summarizing Performance for Optimal Bins}
\usage{
\method{summary}{optimal_bins}(object, ...)
}
\arguments{
\item{object}{an object of class "optimal_bins", usually, a result of a call to binning_by().}

\item{...}{further arguments to be passed from or to other methods.}
}
\value{
NULL.
}
\description{
summary method for "optimal_bins". summary metrics to evaluate the performance 
of binomial classification model.
}
\details{
print() to print only binning table information of "optimal_bins" objects.
summary.performance_bin() includes general metrics and result of significance tests life follows.:
\itemize{
  \item Binning Table : Metrics by bins.
  \itemize{
    \item CntRec, CntPos, CntNeg, RatePos, RateNeg, Odds, WoE, IV, JSD, AUC.
  }
  \item General Metrics.
  \itemize{
    \item Gini index.
    \item Jeffrey's Information Value.
    \item Jensen-Shannon Divergence.
    \item Kolmogorov-Smirnov Statistics.
    \item Herfindahl-Hirschman Index.
    \item normalized Herfindahl-Hirschman Index.
    \item Cramer's V Statistics.
  } 
  \item Table of Significance Tests.
}
}
\examples{
# Generate data for the example
library(dplyr)

carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# optimal binning
bin <- binning_by(carseats, "US", "Advertising")
bin

# summary optimal_bins class
summary(bin)

# performance table
attr(bin, "performance")

# visualize all information for optimal_bins class
# plot(bin)

# visualize WoE information for optimal_bins class
# plot(bin, type = "WoE")

# visualize all information without typographic
# plot(bin, typographic = FALSE)

# extract binned results
# extract(bin) \%>\% 
#   head(20)

}
\seealso{
\code{\link{binning_by}}, \code{\link{plot.optimal_bins}}
}
