% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning.R
\name{binning_by}
\alias{binning_by}
\title{Optimal Binning for Scoring Modeling}
\usage{
binning_by(df, y, x, p = 0.05, ordered = TRUE, labels = NULL)
}
\arguments{
\item{df}{a data frame.}

\item{y}{binary response variable (0,1). Integer(int) is required.
Name of y must not have a dot. Name "default" is not allowed.}

\item{x}{continuous characteristic. At least 5 different values.
Value Inf is not allowed. Name of x must not have a dot.}

\item{p}{percentage of records per bin. Default 5\% (0.05).
This parameter only accepts values greater that 0.00 (0\%) and lower than 0.50 (50\%).}

\item{ordered}{whether to build an ordered factor or not.}

\item{labels}{the label names to use for each of the bins.}
}
\value{
an object of optimal_bins class.
Attributes of optimal_bins class is as follows.
\itemize{
\item type : binning type, "optimal".
\item breaks : the number of intervals into which x is to be cut.
\item levels : levels of binned value.
\item raw : raw data, x argument value.
\item ivtable : information value table
\item iv : information value
\item flag : information value
}
}
\description{
The binning_by() finding class intervals for numerical variable
using optical binning. Optimal binning categorizes a numeric characteristic
into bins for ulterior usage in scoring modeling.
}
\details{
This function is useful when used with the mutate/transmute
function of the dplyr package. And this function is implemented using
smbinning() function of smbinning package.
}
\section{"optimal_bins" class attributes information}{

Attributes of the "optimal_bins" classs that is as follows.
\itemize{
\item class : "optimal_bins".
\item levels : factor or ordered factor levels
\item type : binning method
\item breaks : breaks for binning
\item raw : before the binned the raw data
\item ivtable : information value table
\item iv : information value
\item target : binary response variable
}

See vignette("transformation") for an introduction to these concepts.
}

\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# optimal binning
bin <- binning_by(carseats, "US", "Advertising")
bin
# summary optimal_bins class
summary(bin)
# visualize optimal_bins class
plot(bin, sub = "bins of Advertising variable")
}
\seealso{
\code{\link{binning}}, \code{\link{smbinning}}.
}
