% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing.R
\name{plot_na_pareto}
\alias{plot_na_pareto}
\title{Pareto chart for missing value}
\usage{
plot_na_pareto(
  x,
  only_na = FALSE,
  relative = FALSE,
  main = NULL,
  col = "black",
  grade = list(Good = 0.05, OK = 0.4, Bad = 0.8, Remove = 1),
  plot = TRUE
)
}
\arguments{
\item{x}{data frames, or objects to be coerced to one.}

\item{only_na}{logical. The default value is FALSE. 
If TRUE, only variables containing missing values are selected for visualization. 
If FALSE, all variables are included.}

\item{relative}{logical. If this argument is TRUE, it sets the unit of the left y-axis to relative frequency. 
In case of FALSE, set it to frequency.}

\item{main}{character. Main title.}

\item{col}{character. The color of line for display the cumulative percentage.}

\item{grade}{list. Specifies the cut-off to set the grade of the variable according to the ratio of missing values.
The default values are Good: [0, 0.05], OK: (0.05, 0.4], Bad: (0.4, 0.8], Remove: (0.8, 1].}

\item{plot}{logical. If this value is TRUE then visualize plot. else if FALSE, return aggregate information about missing values.}
}
\description{
Visualize pareto chart for variables with missing value.
}
\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# Diagnose the data with missing_count using diagnose() function
library(dplyr)
carseats \%>\% 
  diagnose \%>\% 
  arrange(desc(missing_count))

# Visualize pareto chart for variables with missing value.
plot_na_pareto(carseats)
plot_na_pareto(airquality)
  
# Diagnose the data with missing_count using diagnose() function
mice::boys \%>\% 
  diagnose \%>\% 
  arrange(desc(missing_count))

# Visualize pareto chart for variables with missing value.
plot_na_pareto(mice::boys, col = "darkorange")

# Visualize only variables containing missing values
plot_na_pareto(mice::boys, only_na = TRUE)

# Display the relative frequency 
plot_na_pareto(mice::boys, relative = TRUE)

# Change the grade
plot_na_pareto(mice::boys, grade = list(High = 0.1, Middle = 0.6, Low = 1))

# Change the main title.
plot_na_pareto(mice::boys, relative = TRUE, only_na = TRUE, 
main = "Pareto Chart for mice::boys")

# Return the aggregate information about missing values.
plot_na_pareto(mice::boys, only_na = TRUE, plot = FALSE)

}
