% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap.R
\name{overlaps}
\alias{overlaps}
\alias{overlap}
\alias{none}
\alias{exact}
\alias{across}
\alias{x_across_y}
\alias{y_across_x}
\alias{chain}
\alias{x_chain_y}
\alias{y_chain_x}
\alias{aligns_start}
\alias{x_aligns_start_y}
\alias{y_aligns_start_x}
\alias{aligns_end}
\alias{x_aligns_end_y}
\alias{y_aligns_end_x}
\alias{inbetween}
\alias{x_inbetween_y}
\alias{y_inbetween_x}
\alias{overlap_method}
\alias{include_overlap_method}
\alias{exclude_overlap_method}
\alias{overlap_method_codes}
\alias{overlap_method_names}
\title{Overlapping number line objects}
\usage{
overlaps(x, y, methods = 8)

overlap(x, y)

none(x, y)

exact(x, y)

across(x, y)

x_across_y(x, y)

y_across_x(x, y)

chain(x, y)

x_chain_y(x, y)

y_chain_x(x, y)

aligns_start(x, y)

x_aligns_start_y(x, y)

y_aligns_start_x(x, y)

aligns_end(x, y)

x_aligns_end_y(x, y)

y_aligns_end_x(x, y)

inbetween(x, y)

x_inbetween_y(x, y)

y_inbetween_x(x, y)

overlap_method(x, y)

include_overlap_method(methods)

exclude_overlap_method(methods)

overlap_method_codes(methods)

overlap_method_names(methods)
}
\arguments{
\item{x}{\code{[\link{number_line}]}}

\item{y}{\code{[\link{number_line}]}}

\item{methods}{\code{[charater|integer]}. Type of overlap. See \code{as.data.frame(diyar::overlap_methods$options)} for options.}
}
\value{
\code{logical}; \code{character}
}
\description{
Identify overlapping \code{\link{number_line}} objects
}
\details{
There are 6 mutually exclusive types of overlap;
\itemize{
\item \bold{\code{exact()}} - identical \code{\link{start_point}} and \code{\link{end_point}} points.
\item \bold{\code{inbetween()}} - Both \code{\link{start_point}} and \code{\link{end_point}} of one \code{\link{number_line}} object are within the \code{\link{start_point}} and \code{\link{end_point}} of another.
\item \bold{\code{across()}} - Only the \code{\link{start_point}} or \code{\link{end_point}} of one \code{\link{number_line}} object is in between the \code{\link{start_point}} and \code{\link{end_point}} of another.
\item \bold{\code{chain()}} - \code{\link{end_point}} of one \code{\link{number_line}} object is identical to the \code{\link{start_point}} of another.
\item \bold{\code{aligns_start()}} - identical \code{\link{start_point}} only.
\item \bold{\code{aligns_end()}} - identical \code{\link{end_point}} only.
}

Except \bold{\code{exact()}}, each type of overlap has two variations;
\itemize{
\item \bold{\code{x_`method`_y()}} - \code{\link{number_line}}-\code{x} starts before \code{\link{number_line}}-\code{y}.
\item \bold{\code{y_`method`_x()}} - \code{\link{number_line}}-\code{y} starts before \code{\link{number_line}}-\code{x}.
}

There are two mutually inclusive types of overlap;
\itemize{
\item \bold{\code{overlap()}} - a convenient option to select "ANY" and "ALL" type of overlap.
\item \bold{\code{none()}} - a convenient option to select "NO" type of overlap.
}

Selecting multiple types of overlap;
\itemize{
\item \bold{\code{overlaps()}} - select specific type(s) of overlap.
\item \bold{\code{overlap_method()}} - return the type of overlap for a pair of \code{\link{number_line}} objects.
\item \bold{\code{overlap_method_codes()}} - return the corresponding overlap method code for a specific type(s) of overlap.
\item \bold{\code{overlap_method_names()}} - return the corresponding type(s) of overlap for a specific overlap code.
\item \bold{\code{include_overlap_method()}} - return a \bold{\code{character(1)}} value for specified type(s) of overlap.
\item \bold{\code{exclude_overlap_method()}} - return a \bold{\code{character(1)}} value for all type(s) of overlap except those specified.
}
}
\examples{
a <- number_line(-100, 100)
g <- number_line(100, 100)
overlaps(a, g)

# It's neither an "exact" or "chain"-overlap
overlaps(a, g, methods = "exact|chain")

# It's an "aligns_end"-overlap
overlap_method(a, g)
overlaps(a, g, methods = "exact|chain|x_aligns_end_y")

# Corresponding overlap code
overlap_method_codes("exact|chain|x_aligns_end_y")
include_overlap_method(c("exact", "chain", "x_aligns_end_y"))

# Corresponding overlap name
overlap_method_names(overlap_method_codes("exact|chain|x_aligns_end_y"))

# Every other type overlap
exclude_overlap_method(c("exact", "chain", "x_aligns_end_y"))
overlap_method_names(exclude_overlap_method(c("exact", "chain", "x_aligns_end_y")))

# All the above is based on tests for each specific type of overlap as seen below
none(a, g)
exact(a, g)
across(a, g)
x_across_y(a, g)
y_across_x(a, g)
chain(a, g)
x_chain_y(a, g)
y_chain_x(a, g)
inbetween(a, g)
x_inbetween_y(a, g)
y_inbetween_x(a, g)
aligns_start(a, g)
x_aligns_start_y(a, g)
y_aligns_start_x(a, g)
aligns_end(a, g)
x_aligns_end_y(a, g)
y_aligns_end_x(a, g)

}
\seealso{
\code{\link{number_line}};  \code{\link{set_operations}}
}
