% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap.R
\name{overlaps}
\alias{overlaps}
\alias{overlap}
\alias{exact}
\alias{reverse}
\alias{across}
\alias{x_across_y}
\alias{y_across_x}
\alias{chain}
\alias{x_chain_y}
\alias{y_chain_x}
\alias{aligns_start}
\alias{aligns_end}
\alias{inbetween}
\alias{x_inbetween_y}
\alias{y_inbetween_x}
\alias{overlap_method}
\alias{include_overlap_method}
\alias{exclude_overlap_method}
\alias{overlap_method_codes}
\alias{overlap_method_names}
\title{Overlapping number line objects}
\usage{
overlaps(x, y, methods = 8)

overlap(x, y)

exact(x, y)

reverse(x, y)

across(x, y)

x_across_y(x, y)

y_across_x(x, y)

chain(x, y)

x_chain_y(x, y)

y_chain_x(x, y)

aligns_start(x, y)

aligns_end(x, y)

inbetween(x, y)

x_inbetween_y(x, y)

y_inbetween_x(x, y)

overlap_method(x, y)

include_overlap_method(methods)

exclude_overlap_method(methods)

overlap_method_codes(methods)

overlap_method_names(methods)
}
\arguments{
\item{x}{\code{[\link{number_line}]}}

\item{y}{\code{[\link{number_line}]}}

\item{methods}{\code{[charater|integer]}. Methods of overlap. Check different pairs of \code{number_line} objects by different \code{methods}. Options are \code{"exact"}, \code{"reverse"}, \code{"inbetween"}, \code{"across"}, \code{"chain"}, \code{"aligns_start"} and \code{"aligns_end"}.
Combinations are also supported see \code{diyar::overlap_methods$options}.}
}
\value{
\code{logical}; \code{character}
}
\description{
Identify overlapping \code{number_line} objects
}
\details{
\bold{9 logical test;}

\bold{\code{exact()}} - Identical left and right points.

\bold{\code{reverse()}} - Swapped left and right points.

\bold{\code{inbetween()}} - start and end point of one \code{number_line} object is within the start and end point of another.
Split into \bold{\code{x_inbetween_y()}} and \bold{\code{y_inbetween_x()}}.

\bold{\code{across()}} - start or end point of one \code{number_line} object is in between the start and end point of another.
Split into \bold{\code{x_across_y()}} and \bold{\code{y_across_x()}}.

\bold{\code{chain()}} - endpoint of one \code{number_line} object is the same as the start point of another.
Split into \bold{\code{x_chain_y()}} and \bold{\code{y_chain_x()}}.

\bold{\code{aligns_start()}} - identical start points only.

\bold{\code{aligns_end()}} - identical end point only.

\bold{\code{overlap()}} - any kind of overlap. A convenient \code{method} for "ANY" and "ALL" overlap methods.

\bold{\code{overlaps()}} - overlap by a specified combination of the methods.

\bold{Describe methods of overlap;}

\bold{\code{overlap_method()}} - Shows how a pair of \code{number_line} object has overlapped.
Does not show \code{"overlap"} since \bold{\code{overlap()}} is always \code{TRUE} when any other method is \code{TRUE}.

\bold{\code{include_overlap_method()}} and \bold{\code{exclude_overlap_method()}} - Conveniently create the required values for \code{methods}, and \code{case_overlap_methods} and \code{recurrence_overlap_methods} in \code{\link{episodes}}.

\bold{\code{overlap_method_codes()}} - Numeric codes for the supported combination of overlap methods.
}
\examples{
a <- number_line(-100, 100)
b <- number_line(10, 11.2)
c <- number_line(100, 200)
d <- number_line(100, 120)
e <- number_line(50, 120)
g <- number_line(100, 100)
f <- number_line(120, 50)

overlaps(a, g)
overlaps(a, g, methods = "exact|chain")

overlap(a, b)
overlap(a, e)

exact(a, g)
exact(a, a)

reverse(e, e)
reverse(e, f)

across(a, e)
x_across_y(a, e)
y_across_x(a, e)

chain(c, d)
chain(a, c)

x_chain_y(c, d)
x_chain_y(a, c)

y_chain_x(c, d)
y_chain_x(a, c)

aligns_start(c, d)
aligns_start(a, c)

aligns_end(d, e)
aligns_end(a, c)

inbetween(a, g)
inbetween(b, a)

x_inbetween_y(a, g)
x_inbetween_y(b, a)

y_inbetween_x(a, g)
y_inbetween_x(b, a)

overlap_method(a, c)
overlap_method(d, c)
overlap_method(a, g)
overlap_method(b, e)

include_overlap_method("across")
include_overlap_method(c("across", "chain"))

exclude_overlap_method("across")
exclude_overlap_method(c("across", "chain"))

overlap_method_codes("across")
overlap_method_codes("across|chain|exact")

overlap_method_names(100)
overlap_method_names(561)
}
\seealso{
\code{\link{number_line}};  \code{\link{set_operations}}
}
